local OVALE, Ovale = ...
local OvaleScripts = Ovale.OvaleScripts

do
	local name = "nerien_druid_restoration"
	local desc = "[6.0] Nerien: Restoration"
	local code = [[
###
### Nerien's restoration druid script.
###

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_druid_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=restoration)

AddFunction RestorationInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		if target.InRange(skull_bash) Spell(skull_bash)
		if not target.Classification(worldboss)
		{
			if target.InRange(mighty_bash) Spell(mighty_bash)
			Spell(typhoon)
			if target.InRange(maim) Spell(maim)
			Spell(war_stomp)
		}
	}
}

AddFunction RestorationPrecombatActions
{
	# Raid buffs.
	if not BuffPresent(str_agi_int_buff any=1) Spell(mark_of_the_wild)
	# Healing Touch to refresh Harmony buff.
	if BuffRemaining(harmony_buff) < 6 Spell(healing_touch)
}

AddFunction RestorationMainActions
{
	# Cast instant/mana-free Healing Touch or Regrowth.
	if BuffStacks(sage_mender_buff) == 5 Spell(healing_touch)
	if BuffPresent(omen_of_clarity_heal_buff) or BuffPresent(omen_of_clarity_moment_of_clarity_buff) Spell(regrowth)
	if BuffPresent(natures_swiftness_buff) Spell(healing_touch)

	# Maintain 100% uptime on Harmony mastery buff using Swiftmend.
	# Swiftmend requires either a Rejuvenation or Regrowth HoT to be on the target before
	# it is usable, but we want to show Swiftmend as usable as long as the cooldown is up.
	if BuffRemaining(harmony_buff) < 6 and { BuffCountOnAny(regrowth_buff) > 0 or BuffCountOnAny(rejuvenation_buff) > 0 or BuffCountOnAny(rejuvenation_germination_buff) > 0 } and not SpellCooldown(swiftmend) > 0 Texture(inv_relics_idolofrejuvenation help=Swiftmend)

	# Keep one Lifebloom up on the raid.
	if BuffRemainingOnAny(lifebloom_buff) < 4 Spell(lifebloom)

	# Cast Cenarion Ward on cooldown, usually on the tank.
	if Talent(cenarion_ward_talent) Spell(cenarion_ward)
}

AddFunction RestorationAoeActions
{
	if BuffPresent(tree_of_life_buff)
	{
		Spell(wild_growth)
		if BuffPresent(omen_of_clarity_heal_buff) or BuffPresent(omen_of_clarity_moment_of_clarity_buff) Spell(regrowth)
	}
	unless BuffPresent(tree_of_life_buff)
	{
		Spell(wild_growth)
		if BuffCountOnAny(rejuvenation_buff) > 4 or BuffCountOnAny(rejuvenation_germination_buff) > 4 Spell(genesis)
	}
}

AddFunction RestorationShortCdActions
{
	# Don't cap out on Force of Nature charges.
	if Talent(force_of_nature_talent) and Charges(force_of_nature_heal count=0) >= 3 Spell(force_of_nature_heal)
	# Maintain Efflorescence.
	if TotemExpires(wild_mushroom_heal) Spell(wild_mushroom_heal)
}

AddFunction RestorationCdActions
{
	RestorationInterruptActions()
	Spell(blood_fury_apsp)
	Spell(berserking)
	if ManaPercent() < 97 Spell(arcane_torrent_mana)
	Spell(incarnation_tree_of_life)
	Spell(heart_of_the_wild_heal)
	Spell(natures_vigil)
}

### Restoration icons.

AddCheckBox(opt_druid_restoration_aoe L(AOE) default specialization=restoration)

AddIcon help=shortcd specialization=restoration
{
	RestorationShortCdActions()
}

AddIcon help=main specialization=restoration
{
	if not InCombat() RestorationPrecombatActions()
	RestorationMainActions()
}

AddIcon checkbox=opt_druid_restoration_aoe help=aoe specialization=restoration
{
	RestorationAoeActions()
}

AddIcon help=cd specialization=restoration
{
	RestorationCdActions()
}
]]
	OvaleScripts:RegisterScript("DRUID", "restoration", name, desc, code, "script")
end

-- THE REST OF THIS FILE IS AUTOMATICALLY GENERATED.
-- ANY CHANGES MADE BELOW THIS POINT WILL BE LOST.

do
	local name = "simulationcraft_druid_balance_t18m"
	local desc = "[7.0] SimulationCraft: Druid_Balance_T18M"
	local code = [[
# Based on SimulationCraft profile "Druid_Balance_T18M".
#	class=druid
#	spec=balance
#	talents=0002001

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_druid_spells)

AddCheckBox(opt_potion_intellect ItemName(draenic_intellect_potion) default specialization=balance)
AddCheckBox(opt_legendary_ring_intellect ItemName(legendary_ring_intellect) default specialization=balance)

AddFunction BalanceUsePotionIntellect
{
	if CheckBoxOn(opt_potion_intellect) and target.Classification(worldboss) Item(draenic_intellect_potion usable=1)
}

### actions.default

AddFunction BalanceDefaultMainActions
{
	#blood_fury,if=buff.celestial_alignment.up|buff.incarnation.up
	if BuffPresent(celestial_alignment_buff) or BuffPresent(incarnation_chosen_of_elune_buff) Spell(blood_fury_apsp)
	#berserking,if=buff.celestial_alignment.up|buff.incarnation.up
	if BuffPresent(celestial_alignment_buff) or BuffPresent(incarnation_chosen_of_elune_buff) Spell(berserking)
	#arcane_torrent,if=buff.celestial_alignment.up|buff.incarnation.up
	if BuffPresent(celestial_alignment_buff) or BuffPresent(incarnation_chosen_of_elune_buff) Spell(arcane_torrent_energy)
	#call_action_list,name=fury_of_elune,if=talent.fury_of_elune.enabled&cooldown.fury_of_elue.remains<target.time_to_die
	if Talent(fury_of_elune_talent) and SpellCooldown(fury_of_elue) < target.TimeToDie() BalanceFuryOfEluneMainActions()
	#new_moon,if=(charges=2&recharge_time<5)|charges=3
	if Charges(new_moon) == 2 and SpellChargeCooldown(new_moon) < 5 or Charges(new_moon) == 3 Spell(new_moon)
	#half_moon,if=(charges=2&recharge_time<5)|charges=3|(target.time_to_die<15&charges=2)
	if Charges(half_moon) == 2 and SpellChargeCooldown(half_moon) < 5 or Charges(half_moon) == 3 or target.TimeToDie() < 15 and Charges(half_moon) == 2 Spell(half_moon)
	#full_moon,if=(charges=2&recharge_time<5)|charges=3|target.time_to_die<15
	if Charges(full_moon) == 2 and SpellChargeCooldown(full_moon) < 5 or Charges(full_moon) == 3 or target.TimeToDie() < 15 Spell(full_moon)
	#stellar_flare,if=remains<7.2
	if target.DebuffRemaining(stellar_flare_debuff) < 7.2 Spell(stellar_flare)
	#moonfire,if=(talent.natures_balance.enabled&remains<3)|(remains<6.6&!talent.natures_balance.enabled)
	if Talent(natures_balance_talent) and target.DebuffRemaining(moonfire_debuff) < 3 or target.DebuffRemaining(moonfire_debuff) < 6.6 and not Talent(natures_balance_talent) Spell(moonfire)
	#sunfire,if=(talent.natures_balance.enabled&remains<3)|(remains<5.4&!talent.natures_balance.enabled)
	if Talent(natures_balance_talent) and target.DebuffRemaining(sunfire_debuff) < 3 or target.DebuffRemaining(sunfire_debuff) < 5.4 and not Talent(natures_balance_talent) Spell(sunfire)
	#astral_communion,if=astral_power.deficit>=75
	if FIXME_astral_power.deficit >= 75 Spell(astral_communion)
	#incarnation,if=astral_power>=40
	if AstralPower() >= 40 Spell(incarnation_chosen_of_elune)
	#celestial_alignment,if=astral_power>=40
	if AstralPower() >= 40 Spell(celestial_alignment)
	#solar_wrath,if=buff.solar_empowerment.stack=3
	if BuffStacks(solar_empowerment_buff) == 3 Spell(solar_wrath)
	#lunar_strike,if=buff.lunar_empowerment.stack=3
	if BuffStacks(lunar_empowerment_buff) == 3 Spell(lunar_strike)
	#call_action_list,name=celestial_alignment_phase,if=buff.celestial_alignment.up|buff.incarnation.up
	if BuffPresent(celestial_alignment_buff) or BuffPresent(incarnation_chosen_of_elune_buff) BalanceCelestialAlignmentPhaseMainActions()
	#call_action_list,name=single_target
	BalanceSingleTargetMainActions()
}

AddFunction BalanceDefaultCdActions
{
	#potion,name=draenic_intellect,if=buff.celestial_alignment.up|buff.incarnation.up
	if BuffPresent(celestial_alignment_buff) or BuffPresent(incarnation_chosen_of_elune_buff) BalanceUsePotionIntellect()

	unless { BuffPresent(celestial_alignment_buff) or BuffPresent(incarnation_chosen_of_elune_buff) } and Spell(blood_fury_apsp) or { BuffPresent(celestial_alignment_buff) or BuffPresent(incarnation_chosen_of_elune_buff) } and Spell(berserking) or { BuffPresent(celestial_alignment_buff) or BuffPresent(incarnation_chosen_of_elune_buff) } and Spell(arcane_torrent_energy)
	{
		#use_item,slot=finger1
		if CheckBoxOn(opt_legendary_ring_intellect) Item(legendary_ring_intellect usable=1)
	}
}

### actions.celestial_alignment_phase

AddFunction BalanceCelestialAlignmentPhaseMainActions
{
	#starsurge
	Spell(starsurge)
	#warrior_of_elune,if=buff.lunar_empowerment.stack>=2&((astral_power<=70&buff.blessing_of_elune.down)|(astral_power<=58&buff.blessing_of_elune.up))
	if BuffStacks(lunar_empowerment_buff) >= 2 and { AstralPower() <= 70 and BuffExpires(blessing_of_elune_buff) or AstralPower() <= 58 and BuffPresent(blessing_of_elune_buff) } Spell(warrior_of_elune)
	#lunar_strike,if=buff.warrior_of_elune.up
	if BuffPresent(warrior_of_elune_buff) Spell(lunar_strike)
	#solar_wrath,if=buff.solar_empowerment.up
	if BuffPresent(solar_empowerment_buff) Spell(solar_wrath)
	#lunar_strike,if=buff.lunar_empowerment.up
	if BuffPresent(lunar_empowerment_buff) Spell(lunar_strike)
	#solar_wrath,if=talent.natures_balance.enabled&dot.sunfire_dmg.remains<5&cast_time<dot.sunfire_dmg.remains
	if Talent(natures_balance_talent) and target.DebuffRemaining(sunfire_dmg_debuff) < 5 and CastTime(solar_wrath) < target.DebuffRemaining(sunfire_dmg_debuff) Spell(solar_wrath)
	#lunar_strike,if=talent.natures_balance.enabled&dot.moonfire_dmg.remains<5&cast_time<dot.moonfire_dmg.remains
	if Talent(natures_balance_talent) and target.DebuffRemaining(moonfire_dmg_debuff) < 5 and CastTime(lunar_strike) < target.DebuffRemaining(moonfire_dmg_debuff) Spell(lunar_strike)
	#solar_wrath
	Spell(solar_wrath)
}

### actions.fury_of_elune

AddFunction BalanceFuryOfEluneMainActions
{
	#incarnation,if=astral_power>=95&cooldown.fury_of_elune.remains<=gcd
	if AstralPower() >= 95 and SpellCooldown(fury_of_elune) <= GCD() Spell(incarnation_chosen_of_elune)
	#fury_of_elune,if=astral_power>=95
	if AstralPower() >= 95 Spell(fury_of_elune)
	#new_moon,if=((charges=2&recharge_time<5)|charges=3)&&(buff.fury_of_elune_up.up|(cooldown.fury_of_elune.remains>gcd*3&astral_power<=90))
	if { Charges(new_moon) == 2 and SpellChargeCooldown(new_moon) < 5 or Charges(new_moon) == 3 } and { BuffPresent(fury_of_elune_up_buff) or SpellCooldown(fury_of_elune) > GCD() * 3 and AstralPower() <= 90 } Spell(new_moon)
	#half_moon,if=((charges=2&recharge_time<5)|charges=3)&&(buff.fury_of_elune_up.up|(cooldown.fury_of_elune.remains>gcd*3&astral_power<=80))
	if { Charges(half_moon) == 2 and SpellChargeCooldown(half_moon) < 5 or Charges(half_moon) == 3 } and { BuffPresent(fury_of_elune_up_buff) or SpellCooldown(fury_of_elune) > GCD() * 3 and AstralPower() <= 80 } Spell(half_moon)
	#full_moon,if=((charges=2&recharge_time<5)|charges=3)&&(buff.fury_of_elune_up.up|(cooldown.fury_of_elune.remains>gcd*3&astral_power<=60))
	if { Charges(full_moon) == 2 and SpellChargeCooldown(full_moon) < 5 or Charges(full_moon) == 3 } and { BuffPresent(fury_of_elune_up_buff) or SpellCooldown(fury_of_elune) > GCD() * 3 and AstralPower() <= 60 } Spell(full_moon)
	#astral_communion,if=buff.fury_of_elune_up.up&astral_power<=25
	if BuffPresent(fury_of_elune_up_buff) and AstralPower() <= 25 Spell(astral_communion)
	#warrior_of_elune,if=buff.fury_of_elune_up.up|(cooldown.fury_of_elune.remains>=35&buff.lunar_empowerment.up)
	if BuffPresent(fury_of_elune_up_buff) or SpellCooldown(fury_of_elune) >= 35 and BuffPresent(lunar_empowerment_buff) Spell(warrior_of_elune)
	#lunar_strike,if=buff.warrior_of_elune.up&(astral_power<=90|(astral_power<=85&buff.incarnation.up))
	if BuffPresent(warrior_of_elune_buff) and { AstralPower() <= 90 or AstralPower() <= 85 and BuffPresent(incarnation_chosen_of_elune_buff) } Spell(lunar_strike)
	#new_moon,if=astral_power<=90&buff.fury_of_elune_up.up
	if AstralPower() <= 90 and BuffPresent(fury_of_elune_up_buff) Spell(new_moon)
	#half_moon,if=astral_power<=80&buff.fury_of_elune_up.up&astral_power>cast_time*12
	if AstralPower() <= 80 and BuffPresent(fury_of_elune_up_buff) and AstralPower() > CastTime(half_moon) * 12 Spell(half_moon)
	#full_moon,if=astral_power<=60&buff.fury_of_elune_up.up&astral_power>cast_time*12
	if AstralPower() <= 60 and BuffPresent(fury_of_elune_up_buff) and AstralPower() > CastTime(full_moon) * 12 Spell(full_moon)
	#moonfire,if=buff.fury_of_elune_up.down&remains<=6.6
	if BuffExpires(fury_of_elune_up_buff) and target.DebuffRemaining(moonfire_debuff) <= 6.6 Spell(moonfire)
	#sunfire,if=buff.fury_of_elune_up.down&remains<=5.4
	if BuffExpires(fury_of_elune_up_buff) and target.DebuffRemaining(sunfire_debuff) <= 5.4 Spell(sunfire)
	#stellar_flare,if=remains<7.2
	if target.DebuffRemaining(stellar_flare_debuff) < 7.2 Spell(stellar_flare)
	#starsurge,if=buff.fury_of_elune_up.down&((astral_power>=92&cooldown.fury_of_elune.remains>gcd*3)|(cooldown.warrior_of_elune.remains<=5&cooldown.fury_of_elune.remains>=35&buff.lunar_empowerment.stack<2))
	if BuffExpires(fury_of_elune_up_buff) and { AstralPower() >= 92 and SpellCooldown(fury_of_elune) > GCD() * 3 or SpellCooldown(warrior_of_elune) <= 5 and SpellCooldown(fury_of_elune) >= 35 and BuffStacks(lunar_empowerment_buff) < 2 } Spell(starsurge)
	#solar_wrath,if=buff.solar_empowerment.up
	if BuffPresent(solar_empowerment_buff) Spell(solar_wrath)
	#lunar_strike,if=buff.lunar_empowerment.stack=3|(buff.lunar_empowerment.remains<5&buff.lunar_empowerment.up)
	if BuffStacks(lunar_empowerment_buff) == 3 or BuffRemaining(lunar_empowerment_buff) < 5 and BuffPresent(lunar_empowerment_buff) Spell(lunar_strike)
	#solar_wrath
	Spell(solar_wrath)
}

### actions.precombat

AddFunction BalancePrecombatMainActions
{
	#flask,type=greater_draenic_intellect_flask
	#food,type=sleeper_sushi
	#moonkin_form
	Spell(moonkin_form)
	#blessing_of_elune
	Spell(blessing_of_elune)
	#new_moon
	Spell(new_moon)
}

AddFunction BalancePrecombatCdActions
{
	unless Spell(moonkin_form) or Spell(blessing_of_elune)
	{
		#snapshot_stats
		#potion,name=draenic_intellect
		BalanceUsePotionIntellect()
	}
}

AddFunction BalancePrecombatCdPostConditions
{
	Spell(moonkin_form) or Spell(blessing_of_elune) or Spell(new_moon)
}

### actions.single_target

AddFunction BalanceSingleTargetMainActions
{
	#new_moon,if=astral_power<=90
	if AstralPower() <= 90 Spell(new_moon)
	#half_moon,if=astral_power<=80
	if AstralPower() <= 80 Spell(half_moon)
	#full_moon,if=astral_power<=60
	if AstralPower() <= 60 Spell(full_moon)
	#starsurge
	Spell(starsurge)
	#warrior_of_elune,if=buff.lunar_empowerment.stack>=2&((astral_power<=80&buff.blessing_of_elune.down)|(astral_power<=72&buff.blessing_of_elune.up))
	if BuffStacks(lunar_empowerment_buff) >= 2 and { AstralPower() <= 80 and BuffExpires(blessing_of_elune_buff) or AstralPower() <= 72 and BuffPresent(blessing_of_elune_buff) } Spell(warrior_of_elune)
	#lunar_strike,if=buff.warrior_of_elune.up
	if BuffPresent(warrior_of_elune_buff) Spell(lunar_strike)
	#solar_wrath,if=buff.solar_empowerment.up
	if BuffPresent(solar_empowerment_buff) Spell(solar_wrath)
	#lunar_strike,if=buff.lunar_empowerment.up
	if BuffPresent(lunar_empowerment_buff) Spell(lunar_strike)
	#solar_wrath,if=talent.natures_balance.enabled&dot.sunfire_dmg.remains<5&cast_time<dot.sunfire_dmg.remains
	if Talent(natures_balance_talent) and target.DebuffRemaining(sunfire_dmg_debuff) < 5 and CastTime(solar_wrath) < target.DebuffRemaining(sunfire_dmg_debuff) Spell(solar_wrath)
	#lunar_strike,if=talent.natures_balance.enabled&dot.moonfire_dmg.remains<5&cast_time<dot.moonfire_dmg.remains
	if Talent(natures_balance_talent) and target.DebuffRemaining(moonfire_dmg_debuff) < 5 and CastTime(lunar_strike) < target.DebuffRemaining(moonfire_dmg_debuff) Spell(lunar_strike)
	#solar_wrath
	Spell(solar_wrath)
}

### Balance icons.

AddCheckBox(opt_druid_balance_aoe L(AOE) default specialization=balance)

AddIcon enemies=1 help=main specialization=balance
{
	if not InCombat() BalancePrecombatMainActions()
	BalanceDefaultMainActions()
}

AddIcon checkbox=opt_druid_balance_aoe help=aoe specialization=balance
{
	if not InCombat() BalancePrecombatMainActions()
	BalanceDefaultMainActions()
}

AddIcon checkbox=!opt_druid_balance_aoe enemies=1 help=cd specialization=balance
{
	if not InCombat() BalancePrecombatCdActions()
	unless not InCombat() and BalancePrecombatCdPostConditions()
	{
		BalanceDefaultCdActions()
	}
}

AddIcon checkbox=opt_druid_balance_aoe help=cd specialization=balance
{
	if not InCombat() BalancePrecombatCdActions()
	unless not InCombat() and BalancePrecombatCdPostConditions()
	{
		BalanceDefaultCdActions()
	}
}

### Required symbols
# arcane_torrent_energy
# astral_communion
# berserking
# blessing_of_elune
# blessing_of_elune_buff
# blood_fury_apsp
# celestial_alignment
# celestial_alignment_buff
# draenic_intellect_potion
# full_moon
# fury_of_elue
# fury_of_elune
# fury_of_elune_talent
# fury_of_elune_up_buff
# half_moon
# incarnation_chosen_of_elune
# incarnation_chosen_of_elune_buff
# legendary_ring_intellect
# lunar_empowerment_buff
# lunar_strike
# moonfire
# moonfire_debuff
# moonfire_dmg_debuff
# moonkin_form
# natures_balance_talent
# new_moon
# solar_empowerment_buff
# solar_wrath
# starsurge
# stellar_flare
# stellar_flare_debuff
# sunfire
# sunfire_debuff
# sunfire_dmg_debuff
# warrior_of_elune
# warrior_of_elune_buff
]]
	OvaleScripts:RegisterScript("DRUID", "balance", name, desc, code, "script")
end

do
	local name = "simulationcraft_druid_feral_t18m"
	local desc = "[7.0] SimulationCraft: Druid_Feral_T18M"
	local code = [[
# Based on SimulationCraft profile "Druid_Feral_T18M".
#	class=druid
#	spec=feral
#	talents=3002002

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_druid_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=feral)
AddCheckBox(opt_melee_range L(not_in_melee_range) specialization=feral)
AddCheckBox(opt_potion_agility ItemName(draenic_agility_potion) default specialization=feral)
AddCheckBox(opt_legendary_ring_agility ItemName(legendary_ring_agility) default specialization=feral)

AddFunction FeralUsePotionAgility
{
	if CheckBoxOn(opt_potion_agility) and target.Classification(worldboss) Item(draenic_agility_potion usable=1)
}

AddFunction FeralGetInMeleeRange
{
	if CheckBoxOn(opt_melee_range) and Stance(druid_bear_form) and not target.InRange(mangle) or { Stance(druid_cat_form) or Stance(druid_claws_of_shirvallah) } and not target.InRange(shred)
	{
		if target.InRange(wild_charge) Spell(wild_charge)
		Texture(misc_arrowlup help=L(not_in_melee_range))
	}
}

AddFunction FeralInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		if target.InRange(skull_bash) Spell(skull_bash)
		if not target.Classification(worldboss)
		{
			if target.InRange(mighty_bash) Spell(mighty_bash)
			Spell(typhoon)
			if target.InRange(maim) Spell(maim)
			Spell(war_stomp)
		}
	}
}

### actions.default

AddFunction FeralDefaultMainActions
{
	#cat_form
	Spell(cat_form)
	#displacer_beast,if=movement.distance>10
	if 0 > 10 Spell(displacer_beast)
	#dash,if=movement.distance&buff.displacer_beast.down&buff.wild_charge_movement.down
	if 0 and BuffExpires(displacer_beast_buff) and True(wild_charge_movement_down) Spell(dash)
	#rake,if=buff.prowl.up|buff.shadowmeld.up
	if BuffPresent(prowl_buff) or BuffPresent(shadowmeld_buff) Spell(rake)
	#pool_resource,wait=0.1,for_next=1,extra_amount=50
	#elunes_guidance,if=combo_points=0&(!artifact.ashamanes_bite.enabled|!dot.ashamanes_rip.ticking)
	if ComboPoints() == 0 and { not PlayerBuffPresent(ashamanes_bite) or not target.DebuffPresent(ashamanes_rip_debuff) } Spell(elunes_guidance)
	unless ComboPoints() == 0 and { not PlayerBuffPresent(ashamanes_bite) or not target.DebuffPresent(ashamanes_rip_debuff) } and SpellUsable(elunes_guidance) and SpellCooldown(elunes_guidance) < TimeToEnergy(50)
	{
		#berserk,if=buff.tigers_fury.up
		if BuffPresent(tigers_fury_buff) Spell(berserk_cat)
		#incarnation,if=cooldown.tigers_fury.remains<gcd
		if SpellCooldown(tigers_fury) < GCD() Spell(incarnation_king_of_the_jungle)
		#blood_fury,sync=tigers_fury
		if { not BuffPresent(clearcasting_buff) and EnergyDeficit() >= 60 or EnergyDeficit() >= 80 or HasTrinket(t18_class_trinket) and BuffPresent(berserk_cat_buff) and BuffExpires(tigers_fury_buff) } and Spell(tigers_fury) Spell(blood_fury_apsp)
		#berserking,sync=tigers_fury
		if { not BuffPresent(clearcasting_buff) and EnergyDeficit() >= 60 or EnergyDeficit() >= 80 or HasTrinket(t18_class_trinket) and BuffPresent(berserk_cat_buff) and BuffExpires(tigers_fury_buff) } and Spell(tigers_fury) Spell(berserking)
		#arcane_torrent,sync=tigers_fury
		if { not BuffPresent(clearcasting_buff) and EnergyDeficit() >= 60 or EnergyDeficit() >= 80 or HasTrinket(t18_class_trinket) and BuffPresent(berserk_cat_buff) and BuffExpires(tigers_fury_buff) } and Spell(tigers_fury) Spell(arcane_torrent_energy)
		#tigers_fury,if=(!buff.clearcasting.react&energy.deficit>=60)|energy.deficit>=80|(t18_class_trinket&buff.berserk.up&buff.tigers_fury.down)
		if not BuffPresent(clearcasting_buff) and EnergyDeficit() >= 60 or EnergyDeficit() >= 80 or HasTrinket(t18_class_trinket) and BuffPresent(berserk_cat_buff) and BuffExpires(tigers_fury_buff) Spell(tigers_fury)
		#tigers_fury,if=talent.sabertooth.enabled&time<10&combo_points=5
		if Talent(sabertooth_talent) and TimeInCombat() < 10 and ComboPoints() == 5 Spell(tigers_fury)
		#incarnation,if=energy.time_to_max>1
		if TimeToMaxEnergy() > 1 Spell(incarnation_king_of_the_jungle)
		#ferocious_bite,cycle_targets=1,if=dot.rip.ticking&dot.rip.remains<3&target.health.pct<25
		if target.DebuffPresent(rip_debuff) and target.DebuffRemaining(rip_debuff) < 3 and target.HealthPercent() < 25 Spell(ferocious_bite)
		#healing_touch,if=talent.bloodtalons.enabled&buff.predatory_swiftness.up&((combo_points>=4&!set_bonus.tier18_4pc)|combo_points=5|buff.predatory_swiftness.remains<1.5)
		if Talent(bloodtalons_talent) and BuffPresent(predatory_swiftness_buff) and { ComboPoints() >= 4 and not ArmorSetBonus(T18 4) or ComboPoints() == 5 or BuffRemaining(predatory_swiftness_buff) < 1.5 } Spell(healing_touch)
		#savage_roar,if=buff.savage_roar.down
		if BuffExpires(savage_roar_buff) Spell(savage_roar)
		#thrash_cat,if=set_bonus.tier18_4pc&buff.clearcasting.react&remains<=duration*0.3&combo_points+buff.bloodtalons.stack!=6
		if ArmorSetBonus(T18 4) and BuffPresent(clearcasting_buff) and target.DebuffRemaining(thrash_cat_debuff) <= BaseDuration(thrash_cat_debuff) * 0.3 and ComboPoints() + BuffStacks(bloodtalons_buff) != 6 Spell(thrash_cat)
		#pool_resource,for_next=1
		#thrash_cat,cycle_targets=1,if=remains<=duration*0.3&(spell_targets.thrash_cat>=2&set_bonus.tier17_2pc|spell_targets.thrash_cat>=4)
		if target.DebuffRemaining(thrash_cat_debuff) <= BaseDuration(thrash_cat_debuff) * 0.3 and { Enemies() >= 2 and ArmorSetBonus(T17 2) or Enemies() >= 4 } Spell(thrash_cat)
		unless target.DebuffRemaining(thrash_cat_debuff) <= BaseDuration(thrash_cat_debuff) * 0.3 and { Enemies() >= 2 and ArmorSetBonus(T17 2) or Enemies() >= 4 } and SpellUsable(thrash_cat) and SpellCooldown(thrash_cat) < TimeToEnergyFor(thrash_cat)
		{
			#call_action_list,name=finisher,if=combo_points=5
			if ComboPoints() == 5 FeralFinisherMainActions()
			#savage_roar,if=buff.savage_roar.remains<gcd
			if BuffRemaining(savage_roar_buff) < GCD() Spell(savage_roar)
			#call_action_list,name=maintain,if=combo_points<5
			if ComboPoints() < 5 FeralMaintainMainActions()
			#pool_resource,for_next=1
			#thrash_cat,cycle_targets=1,if=remains<=duration*0.3&spell_targets.thrash_cat>=2
			if target.DebuffRemaining(thrash_cat_debuff) <= BaseDuration(thrash_cat_debuff) * 0.3 and Enemies() >= 2 Spell(thrash_cat)
			unless target.DebuffRemaining(thrash_cat_debuff) <= BaseDuration(thrash_cat_debuff) * 0.3 and Enemies() >= 2 and SpellUsable(thrash_cat) and SpellCooldown(thrash_cat) < TimeToEnergyFor(thrash_cat)
			{
				#call_action_list,name=generator,if=combo_points<5
				if ComboPoints() < 5 FeralGeneratorMainActions()
			}
		}
	}
}

AddFunction FeralDefaultShortCdActions
{
	unless Spell(cat_form)
	{
		#wild_charge
		FeralGetInMeleeRange()

		unless 0 > 10 and Spell(displacer_beast) or 0 and BuffExpires(displacer_beast_buff) and True(wild_charge_movement_down) and Spell(dash) or { BuffPresent(prowl_buff) or BuffPresent(shadowmeld_buff) } and Spell(rake)
		{
			#auto_attack
			FeralGetInMeleeRange()
		}
	}
}

AddFunction FeralDefaultCdActions
{
	unless Spell(cat_form) or 0 > 10 and Spell(displacer_beast) or 0 and BuffExpires(displacer_beast_buff) and True(wild_charge_movement_down) and Spell(dash) or { BuffPresent(prowl_buff) or BuffPresent(shadowmeld_buff) } and Spell(rake)
	{
		#skull_bash
		FeralInterruptActions()
		#pool_resource,wait=0.1,for_next=1,extra_amount=50
		#elunes_guidance,if=combo_points=0&(!artifact.ashamanes_bite.enabled|!dot.ashamanes_rip.ticking)
		unless ComboPoints() == 0 and { not PlayerBuffPresent(ashamanes_bite) or not target.DebuffPresent(ashamanes_rip_debuff) } and SpellUsable(elunes_guidance) and SpellCooldown(elunes_guidance) < TimeToEnergy(50)
		{
			unless BuffPresent(tigers_fury_buff) and Spell(berserk_cat) or SpellCooldown(tigers_fury) < GCD() and Spell(incarnation_king_of_the_jungle)
			{
				#use_item,slot=finger1
				if CheckBoxOn(opt_legendary_ring_agility) Item(legendary_ring_agility usable=1)
				#potion,name=draenic_agility,if=((buff.berserk.remains>10|buff.incarnation.remains>20)&(target.time_to_die<180|(trinket.proc.all.react&target.health.pct<25)))|target.time_to_die<=40
				if { BuffRemaining(berserk_cat_buff) > 10 or BuffRemaining(incarnation_king_of_the_jungle_buff) > 20 } and { target.TimeToDie() < 180 or BuffPresent(trinket_proc_any_buff) and target.HealthPercent() < 25 } or target.TimeToDie() <= 40 FeralUsePotionAgility()
			}
		}
	}
}

### actions.finisher

AddFunction FeralFinisherMainActions
{
	#rip,cycle_targets=1,if=remains<=duration*0.3&(target.health.pct>25|!dot.rip.ticking)
	if target.DebuffRemaining(rip_debuff) <= BaseDuration(rip_debuff) * 0.3 and { target.HealthPercent() > 25 or not target.DebuffPresent(rip_debuff) } Spell(rip)
	#savage_roar,if=buff.savage_roar.remains<=7.2&(target.health.pct<25|energy.time_to_max<1|buff.berserk.up|buff.incarnation.up|dot.rake.remains<1.5|buff.elunes_guidance.up|cooldown.tigers_fury.remains<3|(talent.moment_of_clarity.enabled&buff.clearcasting.react))
	if BuffRemaining(savage_roar_buff) <= 7.2 and { target.HealthPercent() < 25 or TimeToMaxEnergy() < 1 or BuffPresent(berserk_cat_buff) or BuffPresent(incarnation_king_of_the_jungle_buff) or target.DebuffRemaining(rake_debuff) < 1.5 or BuffPresent(elunes_guidance_buff) or SpellCooldown(tigers_fury) < 3 or Talent(moment_of_clarity_talent) and BuffPresent(clearcasting_buff) } Spell(savage_roar)
	#ferocious_bite,max_energy=1,cycle_targets=1,if=(target.health.pct<25|talent.sabertooth.enabled)&(cooldown.tigers_fury.remains<3|energy.time_to_max<1|buff.berserk.up|buff.incarnation.up|dot.rake.remains<1.5|buff.elunes_guidance.up|(talent.moment_of_clarity.enabled&buff.clearcasting.react))
	if Energy() >= EnergyCost(ferocious_bite max=1) and { target.HealthPercent() < 25 or Talent(sabertooth_talent) } and { SpellCooldown(tigers_fury) < 3 or TimeToMaxEnergy() < 1 or BuffPresent(berserk_cat_buff) or BuffPresent(incarnation_king_of_the_jungle_buff) or target.DebuffRemaining(rake_debuff) < 1.5 or BuffPresent(elunes_guidance_buff) or Talent(moment_of_clarity_talent) and BuffPresent(clearcasting_buff) } Spell(ferocious_bite)
	#ferocious_bite,max_energy=1,if=buff.berserk.up|buff.incarnation.up|cooldown.tigers_fury.remains<3|buff.elunes_guidance.up
	if Energy() >= EnergyCost(ferocious_bite max=1) and { BuffPresent(berserk_cat_buff) or BuffPresent(incarnation_king_of_the_jungle_buff) or SpellCooldown(tigers_fury) < 3 or BuffPresent(elunes_guidance_buff) } Spell(ferocious_bite)
	#ferocious_bite,max_energy=1,if=energy.time_to_max<1
	if Energy() >= EnergyCost(ferocious_bite max=1) and TimeToMaxEnergy() < 1 Spell(ferocious_bite)
}

### actions.generator

AddFunction FeralGeneratorMainActions
{
	#pool_resource,for_next=1
	#brutal_slash,if=spell_targets.brutal_slash>desired_targets
	if Enemies() > Enemies(tagged=1) Spell(brutal_slash)
	unless Enemies() > Enemies(tagged=1) and SpellUsable(brutal_slash) and SpellCooldown(brutal_slash) < TimeToEnergyFor(brutal_slash)
	{
		#pool_resource,for_next=1
		#brutal_slash,if=active_enemies>=2&raid_event.adds.exists&raid_event.adds.in>(1+max_charges-charges_fractional)*15
		if Enemies() >= 2 and False(raid_event_adds_exists) and 600 > { 1 + FIXME_max_charges - Charges(brutal_slash count=0) } * 15 Spell(brutal_slash)
		unless Enemies() >= 2 and False(raid_event_adds_exists) and 600 > { 1 + FIXME_max_charges - Charges(brutal_slash count=0) } * 15 and SpellUsable(brutal_slash) and SpellCooldown(brutal_slash) < TimeToEnergyFor(brutal_slash)
		{
			#pool_resource,for_next=1
			#brutal_slash,if=active_enemies>=2&!raid_event.adds.exists&(charges_fractional>2.66&time>10)
			if Enemies() >= 2 and not False(raid_event_adds_exists) and Charges(brutal_slash count=0) > 2.66 and TimeInCombat() > 10 Spell(brutal_slash)
			unless Enemies() >= 2 and not False(raid_event_adds_exists) and Charges(brutal_slash count=0) > 2.66 and TimeInCombat() > 10 and SpellUsable(brutal_slash) and SpellCooldown(brutal_slash) < TimeToEnergyFor(brutal_slash)
			{
				#swipe_cat,if=spell_targets.swipe_cat>=4
				if Enemies() >= 4 Spell(swipe_cat)
				#shred,if=spell_targets.swipe_cat<=3|talent.brutal_slash.enabled
				if Enemies() <= 3 or Talent(brutal_slash_talent) Spell(shred)
			}
		}
	}
}

### actions.maintain

AddFunction FeralMaintainMainActions
{
	#shadowmeld,if=energy>=35&dot.rake.pmultiplier<2.1&buff.tigers_fury.up&(buff.bloodtalons.up|!talent.bloodtalons.enabled)&(!talent.incarnation.enabled|cooldown.incarnation.remains>18)&!buff.incarnation.up
	if Energy() >= 35 and target.DebuffPersistentMultiplier(rake_debuff) < 2.1 and BuffPresent(tigers_fury_buff) and { BuffPresent(bloodtalons_buff) or not Talent(bloodtalons_talent) } and { not Talent(incarnation_talent) or SpellCooldown(incarnation_king_of_the_jungle) > 18 } and not BuffPresent(incarnation_king_of_the_jungle_buff) Spell(shadowmeld)
	#rake,cycle_targets=1,if=remains<=tick_time&((target.time_to_die-remains>3&spell_targets.swipe_cat<3)|target.time_to_die-remains>6)
	if target.DebuffRemaining(rake_debuff) <= target.TickTime(rake_debuff) and { target.TimeToDie() - target.DebuffRemaining(rake_debuff) > 3 and Enemies() < 3 or target.TimeToDie() - target.DebuffRemaining(rake_debuff) > 6 } Spell(rake)
	#rake,cycle_targets=1,if=remains<=duration*0.3&(persistent_multiplier>=dot.rake.pmultiplier|(talent.bloodtalons.enabled&(buff.bloodtalons.up|!buff.predatory_swiftness.up)))&((target.time_to_die-remains>3&spell_targets.swipe_cat<3)|target.time_to_die-remains>6)
	if target.DebuffRemaining(rake_debuff) <= BaseDuration(rake_debuff) * 0.3 and { PersistentMultiplier(rake_debuff) >= target.DebuffPersistentMultiplier(rake_debuff) or Talent(bloodtalons_talent) and { BuffPresent(bloodtalons_buff) or not BuffPresent(predatory_swiftness_buff) } } and { target.TimeToDie() - target.DebuffRemaining(rake_debuff) > 3 and Enemies() < 3 or target.TimeToDie() - target.DebuffRemaining(rake_debuff) > 6 } Spell(rake)
	#moonfire_cat,cycle_targets=1,if=remains<=4.2&spell_targets.swipe_cat<=5&target.time_to_die-remains>tick_time*5
	if target.DebuffRemaining(moonfire_cat_debuff) <= 4.2 and Enemies() <= 5 and target.TimeToDie() - target.DebuffRemaining(moonfire_cat_debuff) > target.TickTime(moonfire_cat_debuff) * 5 Spell(moonfire_cat)
}

### actions.precombat

AddFunction FeralPrecombatMainActions
{
	#flask,type=greater_draenic_agility_flask
	#food,type=pickled_eel
	#healing_touch,if=talent.bloodtalons.enabled
	if Talent(bloodtalons_talent) Spell(healing_touch)
	#cat_form
	Spell(cat_form)
	#prowl
	Spell(prowl)
	#incarnation
	Spell(incarnation_king_of_the_jungle)
}

AddFunction FeralPrecombatShortCdPostConditions
{
	Talent(bloodtalons_talent) and Spell(healing_touch) or Spell(cat_form) or Spell(prowl) or Spell(incarnation_king_of_the_jungle)
}

AddFunction FeralPrecombatCdActions
{
	unless Talent(bloodtalons_talent) and Spell(healing_touch) or Spell(cat_form) or Spell(prowl)
	{
		#snapshot_stats
		#potion,name=draenic_agility
		FeralUsePotionAgility()
	}
}

AddFunction FeralPrecombatCdPostConditions
{
	Talent(bloodtalons_talent) and Spell(healing_touch) or Spell(cat_form) or Spell(prowl) or Spell(incarnation_king_of_the_jungle)
}

### Feral icons.

AddCheckBox(opt_druid_feral_aoe L(AOE) default specialization=feral)

AddIcon checkbox=!opt_druid_feral_aoe enemies=1 help=shortcd specialization=feral
{
	unless not InCombat() and FeralPrecombatShortCdPostConditions()
	{
		FeralDefaultShortCdActions()
	}
}

AddIcon checkbox=opt_druid_feral_aoe help=shortcd specialization=feral
{
	unless not InCombat() and FeralPrecombatShortCdPostConditions()
	{
		FeralDefaultShortCdActions()
	}
}

AddIcon enemies=1 help=main specialization=feral
{
	if not InCombat() FeralPrecombatMainActions()
	FeralDefaultMainActions()
}

AddIcon checkbox=opt_druid_feral_aoe help=aoe specialization=feral
{
	if not InCombat() FeralPrecombatMainActions()
	FeralDefaultMainActions()
}

AddIcon checkbox=!opt_druid_feral_aoe enemies=1 help=cd specialization=feral
{
	if not InCombat() FeralPrecombatCdActions()
	unless not InCombat() and FeralPrecombatCdPostConditions()
	{
		FeralDefaultCdActions()
	}
}

AddIcon checkbox=opt_druid_feral_aoe help=cd specialization=feral
{
	if not InCombat() FeralPrecombatCdActions()
	unless not InCombat() and FeralPrecombatCdPostConditions()
	{
		FeralDefaultCdActions()
	}
}

### Required symbols
# arcane_torrent_energy
# ashamanes_bite
# ashamanes_rip_debuff
# berserk_cat
# berserk_cat_buff
# berserking
# blood_fury_apsp
# bloodtalons_buff
# bloodtalons_talent
# brutal_slash
# brutal_slash_talent
# cat_form
# clearcasting_buff
# dash
# displacer_beast
# displacer_beast_buff
# draenic_agility_potion
# elunes_guidance
# elunes_guidance_buff
# ferocious_bite
# healing_touch
# incarnation_king_of_the_jungle
# incarnation_king_of_the_jungle_buff
# incarnation_talent
# legendary_ring_agility
# maim
# mangle
# mighty_bash
# moment_of_clarity_talent
# moonfire_cat
# moonfire_cat_debuff
# predatory_swiftness_buff
# prowl
# prowl_buff
# rake
# rake_debuff
# rip
# rip_debuff
# sabertooth_talent
# savage_roar
# savage_roar_buff
# shadowmeld
# shadowmeld_buff
# shred
# skull_bash
# swipe_cat
# t18_class_trinket
# thrash_cat
# thrash_cat_debuff
# tigers_fury
# tigers_fury_buff
# typhoon
# war_stomp
# wild_charge
# wild_charge_bear
# wild_charge_cat
]]
	OvaleScripts:RegisterScript("DRUID", "feral", name, desc, code, "script")
end

do
	local name = "simulationcraft_druid_guardian_t18m"
	local desc = "[7.0] SimulationCraft: Druid_Guardian_T18M"
	local code = [[
# Based on SimulationCraft profile "Druid_Guardian_T18M".
#	class=druid
#	spec=guardian
#	talents=0301022

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_druid_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=guardian)
AddCheckBox(opt_melee_range L(not_in_melee_range) specialization=guardian)
AddCheckBox(opt_legendary_ring_bonus_armor ItemName(legendary_ring_bonus_armor) default specialization=guardian)

AddFunction GuardianGetInMeleeRange
{
	if CheckBoxOn(opt_melee_range) and Stance(druid_bear_form) and not target.InRange(mangle) or { Stance(druid_cat_form) or Stance(druid_claws_of_shirvallah) } and not target.InRange(shred)
	{
		if target.InRange(wild_charge) Spell(wild_charge)
		Texture(misc_arrowlup help=L(not_in_melee_range))
	}
}

AddFunction GuardianInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		if target.InRange(skull_bash) Spell(skull_bash)
		if not target.Classification(worldboss)
		{
			if target.InRange(mighty_bash) Spell(mighty_bash)
			Spell(typhoon)
			if target.InRange(maim) Spell(maim)
			Spell(war_stomp)
		}
	}
}

### actions.default

AddFunction GuardianDefaultMainActions
{
	#blood_fury
	Spell(blood_fury_apsp)
	#berserking
	Spell(berserking)
	#arcane_torrent
	Spell(arcane_torrent_energy)
	#barkskin
	Spell(barkskin)
	#bristling_fur,if=buff.ironfur.remains<2&rage<40
	if BuffRemaining(ironfur_buff) < 2 and Rage() < 40 Spell(bristling_fur)
	#ironfur,if=buff.ironfur.down|rage.deficit<25
	if BuffExpires(ironfur_buff) or RageDeficit() < 25 Spell(ironfur)
	#frenzied_regeneration,if=!ticking&incoming_damage_6s%health.max>0.25+(2-charges_fractional)*0.15
	if not target.DebuffPresent(frenzied_regeneration_debuff) and IncomingDamage(6) / MaxHealth() > 0.25 + { 2 - Charges(frenzied_regeneration count=0) } * 0.15 Spell(frenzied_regeneration)
	#pulverize,cycle_targets=1,if=buff.pulverize.down
	if BuffExpires(pulverize_buff) and target.DebuffGain(lacerate_debuff) <= BaseDuration(lacerate_debuff) Spell(pulverize)
	#mangle
	Spell(mangle)
	#pulverize,cycle_targets=1,if=buff.pulverize.remains<gcd
	if BuffRemaining(pulverize_buff) < GCD() and target.DebuffGain(lacerate_debuff) <= BaseDuration(lacerate_debuff) Spell(pulverize)
	#lunar_beam
	Spell(lunar_beam)
	#incarnation
	Spell(incarnation_son_of_ursoc)
	#thrash_bear,if=active_enemies>=2
	if Enemies() >= 2 Spell(thrash_bear)
	#pulverize,cycle_targets=1,if=buff.pulverize.remains<3.6
	if BuffRemaining(pulverize_buff) < 3.6 and target.DebuffGain(lacerate_debuff) <= BaseDuration(lacerate_debuff) Spell(pulverize)
	#thrash_bear,if=talent.pulverize.enabled&buff.pulverize.remains<3.6
	if Talent(pulverize_talent) and BuffRemaining(pulverize_buff) < 3.6 Spell(thrash_bear)
	#moonfire,cycle_targets=1,if=!ticking
	if not target.DebuffPresent(moonfire_debuff) Spell(moonfire)
	#moonfire,cycle_targets=1,if=remains<3.6
	if target.DebuffRemaining(moonfire_debuff) < 3.6 Spell(moonfire)
	#moonfire,cycle_targets=1,if=remains<7.2
	if target.DebuffRemaining(moonfire_debuff) < 7.2 Spell(moonfire)
	#moonfire
	Spell(moonfire)
}

AddFunction GuardianDefaultShortCdActions
{
	#auto_attack
	GuardianGetInMeleeRange()
}

AddFunction GuardianDefaultCdActions
{
	#skull_bash
	GuardianInterruptActions()

	unless Spell(blood_fury_apsp) or Spell(berserking) or Spell(arcane_torrent_energy)
	{
		#use_item,slot=finger1
		if CheckBoxOn(opt_legendary_ring_bonus_armor) Item(legendary_ring_bonus_armor usable=1)
	}
}

### actions.precombat

AddFunction GuardianPrecombatMainActions
{
	#flask,type=greater_draenic_agility_flask
	#food,type=sleeper_sushi
	#bear_form
	Spell(bear_form)
}

AddFunction GuardianPrecombatShortCdPostConditions
{
	Spell(bear_form)
}

AddFunction GuardianPrecombatCdPostConditions
{
	Spell(bear_form)
}

### Guardian icons.

AddCheckBox(opt_druid_guardian_aoe L(AOE) default specialization=guardian)

AddIcon checkbox=!opt_druid_guardian_aoe enemies=1 help=shortcd specialization=guardian
{
	unless not InCombat() and GuardianPrecombatShortCdPostConditions()
	{
		GuardianDefaultShortCdActions()
	}
}

AddIcon checkbox=opt_druid_guardian_aoe help=shortcd specialization=guardian
{
	unless not InCombat() and GuardianPrecombatShortCdPostConditions()
	{
		GuardianDefaultShortCdActions()
	}
}

AddIcon enemies=1 help=main specialization=guardian
{
	if not InCombat() GuardianPrecombatMainActions()
	GuardianDefaultMainActions()
}

AddIcon checkbox=opt_druid_guardian_aoe help=aoe specialization=guardian
{
	if not InCombat() GuardianPrecombatMainActions()
	GuardianDefaultMainActions()
}

AddIcon checkbox=!opt_druid_guardian_aoe enemies=1 help=cd specialization=guardian
{
	unless not InCombat() and GuardianPrecombatCdPostConditions()
	{
		GuardianDefaultCdActions()
	}
}

AddIcon checkbox=opt_druid_guardian_aoe help=cd specialization=guardian
{
	unless not InCombat() and GuardianPrecombatCdPostConditions()
	{
		GuardianDefaultCdActions()
	}
}

### Required symbols
# arcane_torrent_energy
# barkskin
# bear_form
# berserking
# blood_fury_apsp
# bristling_fur
# frenzied_regeneration
# frenzied_regeneration_debuff
# incarnation_son_of_ursoc
# ironfur
# ironfur_buff
# lacerate_debuff
# legendary_ring_bonus_armor
# lunar_beam
# maim
# mangle
# mighty_bash
# moonfire
# moonfire_debuff
# pulverize
# pulverize_buff
# pulverize_talent
# shred
# skull_bash
# thrash_bear
# typhoon
# war_stomp
# wild_charge
# wild_charge_bear
# wild_charge_cat
]]
	OvaleScripts:RegisterScript("DRUID", "guardian", name, desc, code, "script")
end
