local OVALE, Ovale = ...
local OvaleScripts = Ovale.OvaleScripts

-- THE REST OF THIS FILE IS AUTOMATICALLY GENERATED.
-- ANY CHANGES MADE BELOW THIS POINT WILL BE LOST.

do
	local name = "simulationcraft_rogue_assassination_t18m"
	local desc = "[7.0] SimulationCraft: Rogue_Assassination_T18M"
	local code = [[
# Based on SimulationCraft profile "Rogue_Assassination_T18M".
#	class=rogue
#	spec=assassination
#	talents=3110131

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_rogue_spells)

AddCheckBox(opt_melee_range L(not_in_melee_range) specialization=assassination)
AddCheckBox(opt_potion_agility ItemName(draenic_agility_potion) default specialization=assassination)
AddCheckBox(opt_legendary_ring_agility ItemName(legendary_ring_agility) default specialization=assassination)
AddCheckBox(opt_vanish SpellName(vanish) default specialization=assassination)

AddFunction AssassinationUsePotionAgility
{
	if CheckBoxOn(opt_potion_agility) and target.Classification(worldboss) Item(draenic_agility_potion usable=1)
}

### actions.default

AddFunction AssassinationDefaultMainActions
{
	#blood_fury,if=debuff.vendetta.up
	if target.DebuffPresent(vendetta_debuff) Spell(blood_fury_ap)
	#berserking,if=debuff.vendetta.up
	if target.DebuffPresent(vendetta_debuff) Spell(berserking)
	#arcane_torrent,if=debuff.vendetta.up&energy.deficit>50
	if target.DebuffPresent(vendetta_debuff) and EnergyDeficit() > 50 Spell(arcane_torrent_energy)
	#vendetta,if=cooldown.exsanguinate.remains<5&time>10|time<10&energy<40
	if SpellCooldown(exsanguinate) < 5 and TimeInCombat() > 10 or TimeInCombat() < 10 and Energy() < 40 Spell(vendetta)
	#exsanguinate,if=prev_gcd.rupture&dot.rupture.remains>20
	if PreviousGCDSpell(rupture) and target.DebuffRemaining(rupture_debuff) > 20 Spell(exsanguinate)
	#vanish,if=cooldown.exsanguinate.remains<2&combo_points>5
	if SpellCooldown(exsanguinate) < 2 and ComboPoints() > 5 and { CheckBoxOn(opt_vanish) or not SpellCooldown(preparation) > 0 } Spell(vanish)
	#rupture,if=cooldown.exsanguinate.remains<1&combo_points>5|(time<3&dot.hemorrhage.remains>10&dot.garrote.remains>8)
	if SpellCooldown(exsanguinate) < 1 and ComboPoints() > 5 or TimeInCombat() < 3 and target.DebuffRemaining(hemorrhage_debuff) > 10 and target.DebuffRemaining(garrote_debuff) > 8 Spell(rupture)
	#garrote,if=refreshable&combo_points<6&!dot.garrote.exsanguinated
	if FIXME_refreshable and ComboPoints() < 6 and not FIXME_dot.garrote.exsanguinated Spell(garrote)
	#hemorrhage,if=refreshable&combo_points<6
	if FIXME_refreshable and ComboPoints() < 6 Spell(hemorrhage)
	#kingsbane,if=time>5
	if TimeInCombat() > 5 Spell(kingsbane)
	#fan_of_knives,cycle_targets=1,if=spell_targets>4|(!dot.deadly_poison_dot.ticking&spell_targets>2)
	if FIXME_spell_targets > 4 or not target.DebuffPresent(deadly_poison_dot_debuff) and FIXME_spell_targets > 2 Spell(fan_of_knives)
	#mutilate,cycle_targets=1,if=!dot.deadly_poison_dot.ticking&spell_targets.fan_of_knives>1&spell_targets.fan_of_knives<3
	if not target.DebuffPresent(deadly_poison_dot_debuff) and Enemies() > 1 and Enemies() < 3 Spell(mutilate)
	#hemorrhage,cycle_targets=1,max_cycle_targets=3,if=spell_targets.fan_of_knives>1&!ticking&dot.rupture.remains>6
	if DebuffCountOnAny(hemorrhage_debuff) < Enemies() and DebuffCountOnAny(hemorrhage_debuff) <= 3 and Enemies() > 1 and not target.DebuffPresent(hemorrhage_debuff) and target.DebuffRemaining(rupture_debuff) > 6 Spell(hemorrhage)
	#fan_of_knives,if=spell_targets>3|(poisoned_enemies<3&spell_targets>2)
	if FIXME_spell_targets > 3 or FIXME_poisoned_enemies < 3 and FIXME_spell_targets > 2 Spell(fan_of_knives)
	#mutilate,if=combo_points<5|(combo_points=5&(cooldown.exsanguinate.remains<2|dot.rupture.refreshable))
	if ComboPoints() < 5 or ComboPoints() == 5 and { SpellCooldown(exsanguinate) < 2 or FIXME_dot.rupture.refreshable } Spell(mutilate)
	#rupture,if=!exsanguinated&refreshable&combo_points>5
	if not FIXME_exsanguinated and FIXME_refreshable and ComboPoints() > 5 Spell(rupture)
	#death_from_above,if=combo_points>4
	if ComboPoints() > 4 Spell(death_from_above)
	#rupture,cycle_targets=1,max_cycle_targets=3,if=spell_targets.fan_of_knives>1&!ticking&combo_points>4
	if DebuffCountOnAny(rupture_debuff) < Enemies() and DebuffCountOnAny(rupture_debuff) <= 3 and Enemies() > 1 and not target.DebuffPresent(rupture_debuff) and ComboPoints() > 4 Spell(rupture)
	#envenom,if=combo_points>=5&(energy.deficit<40|dot.rupture.exsanguinated)&buff.envenom.remains<1&buff.elaborate_planning.remains<2
	if ComboPoints() >= 5 and { EnergyDeficit() < 40 or FIXME_dot.rupture.exsanguinated } and BuffRemaining(envenom_buff) < 1 and BuffRemaining(elaborate_planning_buff) < 2 Spell(envenom)
	#marked_for_death,cycle_targets=1,target_if=min:target.time_to_die,if=combo_points.max-combo_points>=4
	if MaxComboPoints() - ComboPoints() >= 4 Spell(marked_for_death)
	#rupture,cycle_targets=1,max_cycle_targets=3,if=combo_points>4&refreshable&spell_targets.fan_of_knives>1
	if DebuffCountOnAny(rupture_debuff) < Enemies() and DebuffCountOnAny(rupture_debuff) <= 3 and ComboPoints() > 4 and FIXME_refreshable and Enemies() > 1 Spell(rupture)
}

AddFunction AssassinationDefaultCdActions
{
	#potion,name=draenic_agility,if=buff.bloodlust.react|target.time_to_die<30|cooldown.vendetta.remains<10
	if BuffPresent(burst_haste_buff any=1) or target.TimeToDie() < 30 or SpellCooldown(vendetta) < 10 AssassinationUsePotionAgility()
	#use_item,slot=finger1,if=buff.bloodlust.react|target.time_to_die<20|debuff.vendetta.up
	if { BuffPresent(burst_haste_buff any=1) or target.TimeToDie() < 20 or target.DebuffPresent(vendetta_debuff) } and CheckBoxOn(opt_legendary_ring_agility) Item(legendary_ring_agility usable=1)
}

### actions.precombat

AddFunction AssassinationPrecombatMainActions
{
	#flask,type=greater_draenic_agility_flask
	#augmentation,type=hyper
	Spell(augmentation)
	#food,type=sleeper_sushi
	#snapshot_stats
	#apply_poison,lethal=deadly
	if BuffRemaining(lethal_poison_buff) < 1200 Spell(deadly_poison)
	#stealth
	Spell(stealth)
	#marked_for_death
	Spell(marked_for_death)
}

AddFunction AssassinationPrecombatCdActions
{
	unless Spell(augmentation) or BuffRemaining(lethal_poison_buff) < 1200 and Spell(deadly_poison) or Spell(stealth)
	{
		#potion,name=draenic_agility
		AssassinationUsePotionAgility()
	}
}

AddFunction AssassinationPrecombatCdPostConditions
{
	Spell(augmentation) or BuffRemaining(lethal_poison_buff) < 1200 and Spell(deadly_poison) or Spell(stealth) or Spell(marked_for_death)
}

### Assassination icons.

AddCheckBox(opt_rogue_assassination_aoe L(AOE) default specialization=assassination)

AddIcon enemies=1 help=main specialization=assassination
{
	if not InCombat() AssassinationPrecombatMainActions()
	AssassinationDefaultMainActions()
}

AddIcon checkbox=opt_rogue_assassination_aoe help=aoe specialization=assassination
{
	if not InCombat() AssassinationPrecombatMainActions()
	AssassinationDefaultMainActions()
}

AddIcon checkbox=!opt_rogue_assassination_aoe enemies=1 help=cd specialization=assassination
{
	if not InCombat() AssassinationPrecombatCdActions()
	unless not InCombat() and AssassinationPrecombatCdPostConditions()
	{
		AssassinationDefaultCdActions()
	}
}

AddIcon checkbox=opt_rogue_assassination_aoe help=cd specialization=assassination
{
	if not InCombat() AssassinationPrecombatCdActions()
	unless not InCombat() and AssassinationPrecombatCdPostConditions()
	{
		AssassinationDefaultCdActions()
	}
}

### Required symbols
# arcane_torrent_energy
# augmentation
# berserking
# blood_fury_ap
# deadly_poison
# deadly_poison_dot_debuff
# death_from_above
# draenic_agility_potion
# elaborate_planning_buff
# envenom
# envenom_buff
# exsanguinate
# fan_of_knives
# garrote
# garrote_debuff
# hemorrhage
# hemorrhage_debuff
# kick
# kingsbane
# legendary_ring_agility
# lethal_poison_buff
# marked_for_death
# mutilate
# preparation
# rupture
# rupture_debuff
# shadowstep
# stealth
# vanish
# vendetta
# vendetta_debuff
]]
	OvaleScripts:RegisterScript("ROGUE", "assassination", name, desc, code, "script")
end

do
	local name = "simulationcraft_rogue_outlaw_t18m"
	local desc = "[7.0] SimulationCraft: Rogue_Outlaw_T18M"
	local code = [[
# Based on SimulationCraft profile "Rogue_Outlaw_T18M".
#	class=rogue
#	spec=outlaw
#	talents=3010022

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_rogue_spells)

AddCheckBox(opt_melee_range L(not_in_melee_range) specialization=outlaw)
AddCheckBox(opt_potion_agility ItemName(draenic_agility_potion) default specialization=outlaw)
AddCheckBox(opt_legendary_ring_agility ItemName(legendary_ring_agility) default specialization=outlaw)

AddFunction OutlawUsePotionAgility
{
	if CheckBoxOn(opt_potion_agility) and target.Classification(worldboss) Item(draenic_agility_potion usable=1)
}

### actions.default

AddFunction OutlawDefaultMainActions
{
	#blade_flurry,if=(spell_targets.blade_flurry>=2&!buff.blade_flurry.up)|(spell_targets.blade_flurry<2&buff.blade_flurry.up)
	if Enemies() >= 2 and not BuffPresent(blade_flurry_buff) or Enemies() < 2 and BuffPresent(blade_flurry_buff) Spell(blade_flurry)
	#blood_fury
	Spell(blood_fury_ap)
	#berserking
	Spell(berserking)
	#arcane_torrent,if=energy<60
	if Energy() < 60 Spell(arcane_torrent_energy)
	#adrenaline_rush,if=!buff.adrenaline_rush.up
	if not BuffPresent(adrenaline_rush_buff) Spell(adrenaline_rush)
	#pool_resource,for_next=1
	#ambush
	Spell(ambush)
	unless SpellUsable(ambush) and SpellCooldown(ambush) < TimeToEnergyFor(ambush)
	{
		#pool_resource,for_next=1,extra_amount=60
		#vanish,if=combo_points.max-combo_points>=2&energy>60
		if MaxComboPoints() - ComboPoints() >= 2 and Energy() > 60 Spell(vanish)
		unless MaxComboPoints() - ComboPoints() >= 2 and Energy() > 60 and SpellUsable(vanish) and SpellCooldown(vanish) < TimeToEnergy(60)
		{
			#pool_resource,for_next=1,extra_amount=60
			#shadowmeld,if=combo_points.max-combo_points>=2&energy>60
			if MaxComboPoints() - ComboPoints() >= 2 and Energy() > 60 Spell(shadowmeld)
			unless MaxComboPoints() - ComboPoints() >= 2 and Energy() > 60 and SpellUsable(shadowmeld) and SpellCooldown(shadowmeld) < TimeToEnergy(60)
			{
				#slice_and_dice,if=talent.slice_and_dice.enabled&combo_points>=5+talent.deeper_strategem.enabled&buff.slice_and_dice.remains<6
				if Talent(slice_and_dice_talent) and ComboPoints() >= 5 + TalentPoints(deeper_strategem_talent) and BuffRemaining(slice_and_dice_buff) < 6 Spell(slice_and_dice)
				#roll_the_bones,if=!talent.slice_and_dice.enabled&combo_points>=5+talent.deeper_strategem.enabled&buff.roll_the_bones.remains<6
				if not Talent(slice_and_dice_talent) and ComboPoints() >= 5 + TalentPoints(deeper_strategem_talent) and BuffRemaining(roll_the_bones_buff) < 6 Spell(roll_the_bones)
				#killing_spree,if=energy.time_to_max>5|energy<15
				if TimeToMaxEnergy() > 5 or Energy() < 15 Spell(killing_spree)
				#cannonball_barrage,if=spell_targets.cannonball_barrage>=2
				if Enemies() >= 2 Spell(cannonball_barrage)
				#curse_of_the_dreadblades,if=combo_points.max-combo_points>=4
				if MaxComboPoints() - ComboPoints() >= 4 Spell(curse_of_the_dreadblades)
				#marked_for_death,cycle_targets=1,target_if=min:target.time_to_die,if=combo_points.max-combo_points>=4
				if MaxComboPoints() - ComboPoints() >= 4 Spell(marked_for_death)
				#call_action_list,name=finisher,if=combo_points>=5+talent.deeper_strategem.enabled
				if ComboPoints() >= 5 + TalentPoints(deeper_strategem_talent) OutlawFinisherMainActions()
				#call_action_list,name=generator,if=combo_points<5+talent.deeper_strategem.enabled
				if ComboPoints() < 5 + TalentPoints(deeper_strategem_talent) OutlawGeneratorMainActions()
			}
		}
	}
}

AddFunction OutlawDefaultCdActions
{
	#potion,name=draenic_agility,if=buff.bloodlust.react|target.time_to_die<30|buff.adrenaline_rush.up
	if BuffPresent(burst_haste_buff any=1) or target.TimeToDie() < 30 or BuffPresent(adrenaline_rush_buff) OutlawUsePotionAgility()

	unless { Enemies() >= 2 and not BuffPresent(blade_flurry_buff) or Enemies() < 2 and BuffPresent(blade_flurry_buff) } and Spell(blade_flurry)
	{
		#use_item,slot=finger1,if=buff.bloodlust.react|buff.adrenaline_rush.up|target.time_to_die<20
		if { BuffPresent(burst_haste_buff any=1) or BuffPresent(adrenaline_rush_buff) or target.TimeToDie() < 20 } and CheckBoxOn(opt_legendary_ring_agility) Item(legendary_ring_agility usable=1)
	}
}

### actions.finisher

AddFunction OutlawFinisherMainActions
{
	#death_from_above
	Spell(death_from_above)
	#run_through
	Spell(run_through)
}

### actions.generator

AddFunction OutlawGeneratorMainActions
{
	#ghostly_strike,if=talent.ghostly_strike.enabled&debuff.ghostly_strike.remains<4.5
	if Talent(ghostly_strike_talent) and target.DebuffRemaining(ghostly_strike_debuff) < 4.5 Spell(ghostly_strike)
	#pistol_shot,if=buff.opportunity.up&energy<60
	if BuffPresent(opportunity_buff) and Energy() < 60 Spell(pistol_shot)
	#saber_slash
	Spell(saber_slash)
}

### actions.precombat

AddFunction OutlawPrecombatMainActions
{
	#flask,type=greater_draenic_agility_flask
	#augmentation,type=hyper
	Spell(augmentation)
	#food,type=sleeper_sushi
	#snapshot_stats
	#stealth
	Spell(stealth)
	#marked_for_death
	Spell(marked_for_death)
}

AddFunction OutlawPrecombatCdActions
{
	unless Spell(augmentation) or Spell(stealth)
	{
		#potion,name=draenic_agility
		OutlawUsePotionAgility()
	}
}

AddFunction OutlawPrecombatCdPostConditions
{
	Spell(augmentation) or Spell(stealth) or Spell(marked_for_death)
}

### Outlaw icons.

AddCheckBox(opt_rogue_outlaw_aoe L(AOE) default specialization=outlaw)

AddIcon enemies=1 help=main specialization=outlaw
{
	if not InCombat() OutlawPrecombatMainActions()
	OutlawDefaultMainActions()
}

AddIcon checkbox=opt_rogue_outlaw_aoe help=aoe specialization=outlaw
{
	if not InCombat() OutlawPrecombatMainActions()
	OutlawDefaultMainActions()
}

AddIcon checkbox=!opt_rogue_outlaw_aoe enemies=1 help=cd specialization=outlaw
{
	if not InCombat() OutlawPrecombatCdActions()
	unless not InCombat() and OutlawPrecombatCdPostConditions()
	{
		OutlawDefaultCdActions()
	}
}

AddIcon checkbox=opt_rogue_outlaw_aoe help=cd specialization=outlaw
{
	if not InCombat() OutlawPrecombatCdActions()
	unless not InCombat() and OutlawPrecombatCdPostConditions()
	{
		OutlawDefaultCdActions()
	}
}

### Required symbols
# adrenaline_rush
# adrenaline_rush_buff
# ambush
# arcane_torrent_energy
# augmentation
# berserking
# blade_flurry
# blade_flurry_buff
# blood_fury_ap
# cannonball_barrage
# curse_of_the_dreadblades
# death_from_above
# deeper_strategem_talent
# draenic_agility_potion
# ghostly_strike
# ghostly_strike_debuff
# ghostly_strike_talent
# kick
# killing_spree
# legendary_ring_agility
# marked_for_death
# opportunity_buff
# pistol_shot
# roll_the_bones
# roll_the_bones_buff
# run_through
# saber_slash
# shadowmeld
# shadowstep
# slice_and_dice
# slice_and_dice_buff
# slice_and_dice_talent
# stealth
# vanish
]]
	OvaleScripts:RegisterScript("ROGUE", "outlaw", name, desc, code, "script")
end

do
	local name = "simulationcraft_rogue_subtlety_t18m"
	local desc = "[7.0] SimulationCraft: Rogue_Subtlety_T18M"
	local code = [[
# Based on SimulationCraft profile "Rogue_Subtlety_T18M".
#	class=rogue
#	spec=subtlety
#	talents=1230011

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_rogue_spells)

AddCheckBox(opt_melee_range L(not_in_melee_range) specialization=subtlety)
AddCheckBox(opt_potion_agility ItemName(draenic_agility_potion) default specialization=subtlety)
AddCheckBox(opt_legendary_ring_agility ItemName(legendary_ring_agility) default specialization=subtlety)

AddFunction SubtletyUsePotionAgility
{
	if CheckBoxOn(opt_potion_agility) and target.Classification(worldboss) Item(draenic_agility_potion usable=1)
}

### actions.default

AddFunction SubtletyDefaultMainActions
{
	#blood_fury,if=buff.shadow_dance.up|buff.vanish.up|buff.stealth.up
	if BuffPresent(shadow_dance_buff) or BuffPresent(vanish_buff) or BuffPresent(stealthed_buff any=1) Spell(blood_fury_ap)
	#berserking,if=buff.shadow_dance.up|buff.vanish.up|buff.stealth.up
	if BuffPresent(shadow_dance_buff) or BuffPresent(vanish_buff) or BuffPresent(stealthed_buff any=1) Spell(berserking)
	#arcane_torrent,if=energy.deficit>70&(buff.shadow_dance.up|buff.vanish.up|buff.stealth.up)
	if EnergyDeficit() > 70 and { BuffPresent(shadow_dance_buff) or BuffPresent(vanish_buff) or BuffPresent(stealthed_buff any=1) } Spell(arcane_torrent_energy)
	#shadow_blades,if=!buff.shadow_blades.up&energy.deficit<20&(buff.shadow_dance.up|buff.vanish.up|buff.stealth.up)
	if not BuffPresent(shadow_blades_buff) and EnergyDeficit() < 20 and { BuffPresent(shadow_dance_buff) or BuffPresent(vanish_buff) or BuffPresent(stealthed_buff any=1) } Spell(shadow_blades)
	#goremaws_bite,if=(combo_points.max-combo_points>=2&energy.deficit>55&time<10)|(combo_points.max-combo_points>=4&energy.deficit>45)|target.time_to_die<8
	if MaxComboPoints() - ComboPoints() >= 2 and EnergyDeficit() > 55 and TimeInCombat() < 10 or MaxComboPoints() - ComboPoints() >= 4 and EnergyDeficit() > 45 or target.TimeToDie() < 8 Spell(goremaws_bite)
	#symbols_of_death,if=buff.symbols_of_death.remains<target.time_to_die-4&buff.symbols_of_death.remains<=10.5&buff.shadowmeld.down
	if BuffRemaining(symbols_of_death_buff) < target.TimeToDie() - 4 and BuffRemaining(symbols_of_death_buff) <= 10.5 and BuffExpires(shadowmeld_buff) Spell(symbols_of_death)
	#shuriken_storm,if=buff.stealth.up&talent.premeditation.enabled&combo_points.max-combo_points>=3&spell_targets.shuriken_storm>=7
	if BuffPresent(stealthed_buff any=1) and Talent(premeditation_talent) and MaxComboPoints() - ComboPoints() >= 3 and Enemies() >= 7 Spell(shuriken_storm)
	#shuriken_storm,if=buff.stealth.up&!buff.death.up&combo_points.max-combo_points>=2&((!talent.premeditation.enabled&spell_targets.shuriken_storm>=4)|spell_targets.shuriken_storm>=8)
	if BuffPresent(stealthed_buff any=1) and not BuffPresent(death_buff) and MaxComboPoints() - ComboPoints() >= 2 and { not Talent(premeditation_talent) and Enemies() >= 4 or Enemies() >= 8 } Spell(shuriken_storm)
	#shadowstrike,if=combo_points.max-combo_points>=2
	if MaxComboPoints() - ComboPoints() >= 2 Spell(shadowstrike)
	#pool_resource,for_next=1,extra_amount=energy.max-talent.master_of_shadows.enabled*30
	#vanish,if=(energy.deficit<talent.master_of_shadows.enabled*30&combo_points.max-combo_points>=3&cooldown.shadow_dance.charges<2)|target.time_to_die<8
	if EnergyDeficit() < TalentPoints(master_of_shadows_talent) * 30 and MaxComboPoints() - ComboPoints() >= 3 and FIXME_cooldown.shadow_dance.charges < 2 or target.TimeToDie() < 8 Spell(vanish)
	unless { EnergyDeficit() < TalentPoints(master_of_shadows_talent) * 30 and MaxComboPoints() - ComboPoints() >= 3 and FIXME_cooldown.shadow_dance.charges < 2 or target.TimeToDie() < 8 } and SpellUsable(vanish) and SpellCooldown(vanish) < TimeToEnergyFor(vanish)
	{
		#pool_resource,for_next=1,extra_amount=energy.max-talent.master_of_shadows.enabled*30
		#shadow_dance,if=combo_points.max-combo_points>=2&((cooldown.vanish.remains&buff.symbols_of_death.remains<=10.5&energy.deficit<talent.master_of_shadows.enabled*30)|cooldown.shadow_dance.charges>=2|target.time_to_die<25)
		if MaxComboPoints() - ComboPoints() >= 2 and { SpellCooldown(vanish) > 0 and BuffRemaining(symbols_of_death_buff) <= 10.5 and EnergyDeficit() < TalentPoints(master_of_shadows_talent) * 30 or FIXME_cooldown.shadow_dance.charges >= 2 or target.TimeToDie() < 25 } Spell(shadow_dance)
		unless MaxComboPoints() - ComboPoints() >= 2 and { SpellCooldown(vanish) > 0 and BuffRemaining(symbols_of_death_buff) <= 10.5 and EnergyDeficit() < TalentPoints(master_of_shadows_talent) * 30 or FIXME_cooldown.shadow_dance.charges >= 2 or target.TimeToDie() < 25 } and SpellUsable(shadow_dance) and SpellCooldown(shadow_dance) < TimeToEnergyFor(shadow_dance)
		{
			#shadowmeld,if=energy>40&combo_points.max-combo_points>=3&!(buff.shadow_dance.up|buff.vanish.up|buff.stealth.up)
			if Energy() > 40 and MaxComboPoints() - ComboPoints() >= 3 and not { BuffPresent(shadow_dance_buff) or BuffPresent(vanish_buff) or BuffPresent(stealthed_buff any=1) } Spell(shadowmeld)
			#enveloping_shadows,if=buff.enveloping_shadows.remains<target.time_to_die&((buff.enveloping_shadows.remains<=10.8+talent.deeper_strategem.enabled*1.8&combo_points>=5+talent.deeper_strategem.enabled)|buff.enveloping_shadows.remains<=6)
			if BuffRemaining(enveloping_shadows_buff) < target.TimeToDie() and { BuffRemaining(enveloping_shadows_buff) <= 10.8 + TalentPoints(deeper_strategem_talent) * 1.8 and ComboPoints() >= 5 + TalentPoints(deeper_strategem_talent) or BuffRemaining(enveloping_shadows_buff) <= 6 } Spell(enveloping_shadows)
			#marked_for_death,cycle_targets=1,target_if=min:target.time_to_die,if=combo_points.max-combo_points>=4
			if MaxComboPoints() - ComboPoints() >= 4 Spell(marked_for_death)
			#run_action_list,name=finisher,if=combo_points>=5
			if ComboPoints() >= 5 SubtletyFinisherMainActions()
			#run_action_list,name=generator,if=combo_points<5
			if ComboPoints() < 5 SubtletyGeneratorMainActions()
		}
	}
}

AddFunction SubtletyDefaultCdActions
{
	#potion,name=draenic_agility,if=buff.bloodlust.react|target.time_to_die<30|buff.shadow_blades.up
	if BuffPresent(burst_haste_buff any=1) or target.TimeToDie() < 30 or BuffPresent(shadow_blades_buff) SubtletyUsePotionAgility()
	#use_item,slot=finger1,if=buff.shadow_dance.up|buff.vanish.up|buff.stealth.up|target.time_to_die<20
	if { BuffPresent(shadow_dance_buff) or BuffPresent(vanish_buff) or BuffPresent(stealthed_buff any=1) or target.TimeToDie() < 20 } and CheckBoxOn(opt_legendary_ring_agility) Item(legendary_ring_agility usable=1)
}

### actions.finisher

AddFunction SubtletyFinisherMainActions
{
	#death_from_above,if=spell_targets.death_from_above>=10
	if Enemies() >= 10 Spell(death_from_above)
	#nightblade,if=!dot.nightblade.ticking|dot.nightblade.remains<(6+(2*combo_points))*0.3
	if not target.DebuffPresent(nightblade_debuff) or target.DebuffRemaining(nightblade_debuff) < { 6 + 2 * ComboPoints() } * 0.3 Spell(nightblade)
	#nightblade,cycle_targets=1,target_if=max:target.time_to_die,if=active_dot.nightblade<6&target.time_to_die>6&(!dot.nightblade.ticking|dot.nightblade.remains<(6+(2*combo_points))*0.3)
	if DebuffCountOnAny(nightblade_debuff) < 6 and target.TimeToDie() > 6 and { not target.DebuffPresent(nightblade_debuff) or target.DebuffRemaining(nightblade_debuff) < { 6 + 2 * ComboPoints() } * 0.3 } Spell(nightblade)
	#death_from_above
	Spell(death_from_above)
	#eviscerate
	Spell(eviscerate)
}

### actions.generator

AddFunction SubtletyGeneratorMainActions
{
	#shuriken_storm,if=spell_targets.shuriken_storm>=2
	if Enemies() >= 2 Spell(shuriken_storm)
	#gloomblade,if=energy.time_to_max<2.5
	if TimeToMaxEnergy() < 2.5 Spell(gloomblade)
	#backstab,if=energy.time_to_max<2.5
	if TimeToMaxEnergy() < 2.5 Spell(backstab)
}

### actions.precombat

AddFunction SubtletyPrecombatMainActions
{
	#flask,type=greater_draenic_agility_flask
	#augmentation,type=hyper
	Spell(augmentation)
	#food,type=sleeper_sushi
	#snapshot_stats
	#stealth
	Spell(stealth)
	#marked_for_death
	Spell(marked_for_death)
	#symbols_of_death
	Spell(symbols_of_death)
}

AddFunction SubtletyPrecombatCdActions
{
	unless Spell(augmentation) or Spell(stealth)
	{
		#potion,name=draenic_agility
		SubtletyUsePotionAgility()
	}
}

AddFunction SubtletyPrecombatCdPostConditions
{
	Spell(augmentation) or Spell(stealth) or Spell(marked_for_death) or Spell(symbols_of_death)
}

### Subtlety icons.

AddCheckBox(opt_rogue_subtlety_aoe L(AOE) default specialization=subtlety)

AddIcon enemies=1 help=main specialization=subtlety
{
	if not InCombat() SubtletyPrecombatMainActions()
	SubtletyDefaultMainActions()
}

AddIcon checkbox=opt_rogue_subtlety_aoe help=aoe specialization=subtlety
{
	if not InCombat() SubtletyPrecombatMainActions()
	SubtletyDefaultMainActions()
}

AddIcon checkbox=!opt_rogue_subtlety_aoe enemies=1 help=cd specialization=subtlety
{
	if not InCombat() SubtletyPrecombatCdActions()
	unless not InCombat() and SubtletyPrecombatCdPostConditions()
	{
		SubtletyDefaultCdActions()
	}
}

AddIcon checkbox=opt_rogue_subtlety_aoe help=cd specialization=subtlety
{
	if not InCombat() SubtletyPrecombatCdActions()
	unless not InCombat() and SubtletyPrecombatCdPostConditions()
	{
		SubtletyDefaultCdActions()
	}
}

### Required symbols
# arcane_torrent_energy
# augmentation
# backstab
# berserking
# blood_fury_ap
# death_buff
# death_from_above
# deeper_strategem_talent
# draenic_agility_potion
# enveloping_shadows
# enveloping_shadows_buff
# eviscerate
# gloomblade
# goremaws_bite
# kick
# legendary_ring_agility
# marked_for_death
# master_of_shadows_talent
# nightblade
# nightblade_debuff
# premeditation_talent
# shadow_blades
# shadow_blades_buff
# shadow_dance
# shadow_dance_buff
# shadowmeld
# shadowmeld_buff
# shadowstep
# shadowstrike
# shuriken_storm
# stealth
# symbols_of_death
# symbols_of_death_buff
# vanish
# vanish_buff
]]
	OvaleScripts:RegisterScript("ROGUE", "subtlety", name, desc, code, "script")
end
