local OVALE, Ovale = ...
local OvaleScripts = Ovale.OvaleScripts

do
	local name = "nerien_shaman_restoration"
	local desc = "[6.2] Nerien: Restoration"
	local code = [[
###
### Nerien's restoration shaman script.
###

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_shaman_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=restoration)

AddFunction RestorationInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		Spell(wind_shear)
		if not target.Classification(worldboss)
		{
			Spell(arcane_torrent_mana)
			if target.InRange(quaking_palm) Spell(quaking_palm)
			Spell(war_stomp)
		}
	}
}

AddFunction RestorationMainActions
{
	if BuffExpires(water_shield_buff) Spell(water_shield)
	if BuffCountOnAny(earth_shield_buff) == 0 Spell(earth_shield)

	# If using Glyph of Totemic Recall, assume that the player wants to use Totemic Recall
	# to regain mana by recalling Healing Stream Totem.
	#
	# Totemic Recall is suggested at 3s remaining on HST so that there is still time to cast
	# it after the current spellcast and GCD.  Take care not to recall other totems that have
	# long cooldowns.
	#
	if Glyph(glyph_of_totemic_recall) and TotemPresent(healing_stream_totem) and TotemExpires(water 3) and TotemExpires(fire) and TotemExpires(earth) and TotemExpires(air) Spell(totemic_recall)

	# Maintain the Elemental Blast buff.
	if Talent(elemental_blast_talent) and BuffRemaining(elemental_blast_spirit_buff) < CastTime(elemental_blast) Spell(elemental_blast)

	if BuffPresent(unleash_life_buff) Spell(healing_wave)
	if Talent(totemic_persistence_talent) or TotemExpires(water) Spell(healing_stream_totem)
	if BuffRemaining(tidal_waves_buff) < 2 or target.BuffRemaining(riptide_buff) < 3 Spell(riptide)
}

AddFunction RestorationAoeActions
{
	if BuffExpires(water_shield_buff) Spell(water_shield)
	if BuffCountOnAny(earth_shield_buff) == 0 Spell(earth_shield)

	# Maintain the Elemental Blast buff.
	if Talent(elemental_blast_talent) and BuffRemaining(elemental_blast_spirit_buff) < CastTime(elemental_blast) Spell(elemental_blast)

	if BuffPresent(unleash_life_buff) Spell(chain_heal)
	if Talent(totemic_persistence_talent) or TotemExpires(water) Spell(healing_stream_totem)
	Spell(healing_rain)
	if Talent(totemic_persistence_talent) or TotemExpires(water) Spell(cloudburst_totem)

	# If using Glyph of Riptide, keep at least five Riptide buffs rolling on the raid.
	if Glyph(glyph_of_riptide) and BuffCountOnAny(riptide_buff) < 5 Spell(riptide)

	# If using Glyph of Chaining, which adds a 3s cooldown to Chain Heal, then cast it on cooldown.
	if Glyph(glyph_of_chaining) Spell(chain_heal)

	# Roll Riptide buffs on the raid on cooldown if using the High Tide talent.
	if not Glyph(glyph_of_riptide) and Talent(high_tide_talent) Spell(riptide)

	# Chain Heal as filler for AoE healing.
	Spell(chain_heal)
}

AddFunction RestorationShortCdActions
{
	if Talent(primal_elementalist_talent) and pet.Present()
	{
		if TotemPresent(fire_elemental_totem) and BuffExpires(fire_elemental_totem_empower_buff any=1) Spell(fire_elemental_totem_empower)
		if TotemPresent(earth_elemental_totem) and BuffExpires(earth_elemental_totem_reinforce_buff any=1) Spell(earth_elemental_totem_reinforce)
	}
	if BuffExpires(unleash_life_buff) Spell(unleash_life)
}

AddFunction RestorationCdActions
{
	if IsFeared() Spell(tremor_totem)
	RestorationInterruptActions()
	if Speed(more 0) Spell(spiritwalkers_grace)
	Spell(blood_fury_apsp)
	Spell(berserking)
	if ManaPercent() < 90 Spell(arcane_torrent_mana)
	if Talent(totemic_persistence_talent) or TotemExpires(water) Spell(healing_tide_totem)
	Spell(ancestral_guidance)
	Spell(ascendance_heal)
	Spell(fire_elemental_totem)
	Spell(earth_elemental_totem)
}

### Restoration icons.

AddCheckBox(opt_shaman_restoration_aoe L(AOE) default specialization=restoration)

AddIcon help=shortcd specialization=restoration
{
	RestorationShortCdActions()
}

AddIcon help=main specialization=restoration
{
	RestorationMainActions()
}

AddIcon checkbox=opt_shaman_restoration_aoe help=aoe specialization=restoration
{
	RestorationAoeActions()
}

AddIcon help=cd specialization=restoration
{
	RestorationCdActions()
}
]]
	OvaleScripts:RegisterScript("SHAMAN", "restoration", name, desc, code, "script")
end

-- THE REST OF THIS FILE IS AUTOMATICALLY GENERATED.
-- ANY CHANGES MADE BELOW THIS POINT WILL BE LOST.

do
	local name = "simulationcraft_shaman_elemental_t18m"
	local desc = "[7.0] SimulationCraft: Shaman_Elemental_T18M"
	local code = [[
# Based on SimulationCraft profile "Shaman_Elemental_T18M".
#	class=shaman
#	spec=elemental
#	talents=0001011

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_shaman_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=elemental)
AddCheckBox(opt_potion_intellect ItemName(draenic_intellect_potion) default specialization=elemental)
AddCheckBox(opt_legendary_ring_intellect ItemName(legendary_ring_intellect) default specialization=elemental)
AddCheckBox(opt_bloodlust SpellName(bloodlust) specialization=elemental)

AddFunction ElementalUsePotionIntellect
{
	if CheckBoxOn(opt_potion_intellect) and target.Classification(worldboss) Item(draenic_intellect_potion usable=1)
}

AddFunction ElementalBloodlust
{
	if CheckBoxOn(opt_bloodlust) and DebuffExpires(burst_haste_debuff any=1)
	{
		Spell(bloodlust)
		Spell(heroism)
	}
}

AddFunction ElementalInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		Spell(wind_shear)
		if not target.Classification(worldboss)
		{
			Spell(arcane_torrent_mana)
			if target.InRange(quaking_palm) Spell(quaking_palm)
			Spell(war_stomp)
		}
	}
}

### actions.default

AddFunction ElementalDefaultMainActions
{
	#totem_mastery,if=buff.resonance_totem.remains<2
	if BuffRemaining(resonance_totem_buff) < 2 Spell(totem_mastery)
	#fire_elemental
	Spell(fire_elemental)
	#elemental_mastery
	Spell(elemental_mastery)
	#blood_fury,if=!talent.ascendance.enabled|buff.ascendance.up|cooldown.ascendance.remains>50
	if not Talent(ascendance_talent) or BuffPresent(ascendance_caster_buff) or SpellCooldown(ascendance_caster) > 50 Spell(blood_fury_apsp)
	#berserking,if=!talent.ascendance.enabled|buff.ascendance.up
	if not Talent(ascendance_talent) or BuffPresent(ascendance_caster_buff) Spell(berserking)
	#run_action_list,name=aoe,if=active_enemies>2&(spell_targets.chain_lightning>2|spell_targets.lava_beam>2)
	if Enemies() > 2 and { Enemies() > 2 or Enemies() > 2 } ElementalAoeMainActions()
	#run_action_list,name=single
	ElementalSingleMainActions()
}

AddFunction ElementalDefaultCdActions
{
	#wind_shear
	ElementalInterruptActions()
	#bloodlust,if=target.health.pct<25|time>0.500
	if target.HealthPercent() < 25 or TimeInCombat() > 0.5 ElementalBloodlust()
	#use_item,slot=finger1
	if CheckBoxOn(opt_legendary_ring_intellect) Item(legendary_ring_intellect usable=1)
	#potion,name=draenic_intellect,if=buff.ascendance.up|target.time_to_die<=30
	if BuffPresent(ascendance_caster_buff) or target.TimeToDie() <= 30 ElementalUsePotionIntellect()
}

### actions.aoe

AddFunction ElementalAoeMainActions
{
	#stormkeeper
	Spell(stormkeeper)
	#ascendance
	if BuffExpires(ascendance_caster_buff) Spell(ascendance_caster)
	#liquid_magma_totem
	Spell(liquid_magma_totem)
	#earthquake_totem
	Spell(earthquake_totem)
	#lava_beam,target_if=!debuff.lightning_rod.up
	Spell(lava_beam)
	#lava_beam
	Spell(lava_beam)
	#chain_lightning,target_if=!debuff.lightning_rod.up
	Spell(chain_lightning)
	#chain_lightning
	Spell(chain_lightning)
	#lava_burst,moving=1
	if Speed() > 0 Spell(lava_burst)
	#flame_shock,moving=1,target_if=refreshable
	if Speed() > 0 Spell(flame_shock)
}

### actions.precombat

AddFunction ElementalPrecombatMainActions
{
	#stormkeeper
	Spell(stormkeeper)
	#totem_mastery
	Spell(totem_mastery)
}

AddFunction ElementalPrecombatCdActions
{
	#flask,type=greater_draenic_intellect_flask
	#food,type=salty_squid_roll
	#snapshot_stats
	#potion,name=draenic_intellect
	ElementalUsePotionIntellect()
}

AddFunction ElementalPrecombatCdPostConditions
{
	Spell(stormkeeper) or Spell(totem_mastery)
}

### actions.single

AddFunction ElementalSingleMainActions
{
	#ascendance,if=dot.flame_shock.remains>buff.ascendance.duration&(time>=60|buff.bloodlust.up)&cooldown.lava_burst.remains>0&!buff.stormkeeper.up
	if target.DebuffRemaining(flame_shock_debuff) > BaseDuration(ascendance_caster_buff) and { TimeInCombat() >= 60 or BuffPresent(burst_haste_buff any=1) } and SpellCooldown(lava_burst) > 0 and not BuffPresent(stormkeeper_buff) and BuffExpires(ascendance_caster_buff) Spell(ascendance_caster)
	#flame_shock,if=!ticking
	if not target.DebuffPresent(flame_shock_debuff) Spell(flame_shock)
	#flame_shock,if=maelstrom>=20&remains<=buff.ascendance.duration&cooldown.ascendance.remains+buff.ascendance.duration<=duration
	if FIXME_maelstrom >= 20 and target.DebuffRemaining(flame_shock_debuff) <= BaseDuration(ascendance_caster_buff) and SpellCooldown(ascendance_caster) + BaseDuration(ascendance_caster_buff) <= BaseDuration(flame_shock_debuff) Spell(flame_shock)
	#earth_shock,if=maelstrom>=92
	if FIXME_maelstrom >= 92 Spell(earth_shock)
	#icefury,if=raid_event.movement.in<5
	if 600 < 5 Spell(icefury)
	#lava_burst,if=dot.flame_shock.remains>cast_time&(cooldown_react|buff.ascendance.up)
	if target.DebuffRemaining(flame_shock_debuff) > CastTime(lava_burst) and { not SpellCooldown(lava_burst) > 0 or BuffPresent(ascendance_caster_buff) } Spell(lava_burst)
	#flame_shock,if=maelstrom>=20&refreshable
	if FIXME_maelstrom >= 20 and FIXME_refreshable Spell(flame_shock)
	#frost_shock,if=maelstrom>=20&raid_event.movement.in>(1.5*spell_haste*buff.icefury.stack)
	if FIXME_maelstrom >= 20 and 600 > 1.5 * { 100 / { 100 + SpellHaste() } } * BuffStacks(icefury_buff) Spell(frost_shock)
	#frost_shock,moving=1,if=buff.icefury.up
	if Speed() > 0 and BuffPresent(icefury_buff) Spell(frost_shock)
	#earth_shock,if=maelstrom>=86
	if FIXME_maelstrom >= 86 Spell(earth_shock)
	#elemental_blast
	Spell(elemental_blast)
	#icefury,if=maelstrom<=76&raid_event.movement.in>30
	if FIXME_maelstrom <= 76 and 600 > 30 Spell(icefury)
	#liquid_magma_totem,if=raid_event.adds.count<3|raid_event.adds.in>50
	if 0 < 3 or 600 > 50 Spell(liquid_magma_totem)
	#stormkeeper,if=(talent.ascendance.enabled&cooldown.ascendance.remains>10)|!talent.ascendance.enabled
	if Talent(ascendance_talent) and SpellCooldown(ascendance_caster) > 10 or not Talent(ascendance_talent) Spell(stormkeeper)
	#totem_mastery,if=buff.resonance_totem.remains<10|(buff.resonance_totem.remains<(buff.ascendance.duration+cooldown.ascendance.remains)&cooldown.ascendance.remains<15)
	if BuffRemaining(resonance_totem_buff) < 10 or BuffRemaining(resonance_totem_buff) < BaseDuration(ascendance_caster_buff) + SpellCooldown(ascendance_caster) and SpellCooldown(ascendance_caster) < 15 Spell(totem_mastery)
	#lava_beam,if=active_enemies>1&spell_targets.lava_beam>1,target_if=!debuff.lightning_rod.up
	if Enemies() > 1 and Enemies() > 1 Spell(lava_beam)
	#lava_beam,if=active_enemies>1&spell_targets.lava_beam>1
	if Enemies() > 1 and Enemies() > 1 Spell(lava_beam)
	#chain_lightning,if=active_enemies>1&spell_targets.chain_lightning>1,target_if=!debuff.lightning_rod.up
	if Enemies() > 1 and Enemies() > 1 Spell(chain_lightning)
	#chain_lightning,if=active_enemies>1&spell_targets.chain_lightning>1
	if Enemies() > 1 and Enemies() > 1 Spell(chain_lightning)
	#lightning_bolt,target_if=!debuff.lightning_rod.up
	Spell(lightning_bolt)
	#lightning_bolt
	Spell(lightning_bolt)
	#frost_shock,if=maelstrom>=20&dot.flame_shock.remains>19
	if FIXME_maelstrom >= 20 and target.DebuffRemaining(flame_shock_debuff) > 19 Spell(frost_shock)
}

### Elemental icons.

AddCheckBox(opt_shaman_elemental_aoe L(AOE) default specialization=elemental)

AddIcon enemies=1 help=main specialization=elemental
{
	if not InCombat() ElementalPrecombatMainActions()
	ElementalDefaultMainActions()
}

AddIcon checkbox=opt_shaman_elemental_aoe help=aoe specialization=elemental
{
	if not InCombat() ElementalPrecombatMainActions()
	ElementalDefaultMainActions()
}

AddIcon checkbox=!opt_shaman_elemental_aoe enemies=1 help=cd specialization=elemental
{
	if not InCombat() ElementalPrecombatCdActions()
	unless not InCombat() and ElementalPrecombatCdPostConditions()
	{
		ElementalDefaultCdActions()
	}
}

AddIcon checkbox=opt_shaman_elemental_aoe help=cd specialization=elemental
{
	if not InCombat() ElementalPrecombatCdActions()
	unless not InCombat() and ElementalPrecombatCdPostConditions()
	{
		ElementalDefaultCdActions()
	}
}

### Required symbols
# arcane_torrent_mana
# ascendance_caster
# ascendance_caster_buff
# ascendance_talent
# berserking
# blood_fury_apsp
# bloodlust
# chain_lightning
# draenic_intellect_potion
# earth_shock
# earthquake_totem
# elemental_blast
# elemental_mastery
# fire_elemental
# flame_shock
# flame_shock_debuff
# frost_shock
# heroism
# icefury
# icefury_buff
# lava_beam
# lava_burst
# legendary_ring_intellect
# lightning_bolt
# liquid_magma_totem
# quaking_palm
# resonance_totem_buff
# stormkeeper
# stormkeeper_buff
# totem_mastery
# war_stomp
# wind_shear
]]
	OvaleScripts:RegisterScript("SHAMAN", "elemental", name, desc, code, "script")
end

do
	local name = "simulationcraft_shaman_enhancement_t18m"
	local desc = "[7.0] SimulationCraft: Shaman_Enhancement_T18M"
	local code = [[
# Based on SimulationCraft profile "Shaman_Enhancement_T18M".
#	class=shaman
#	spec=enhancement
#	talents=1003322

Include(ovale_common)
Include(ovale_trinkets_mop)
Include(ovale_trinkets_wod)
Include(ovale_shaman_spells)

AddCheckBox(opt_interrupt L(interrupt) default specialization=enhancement)
AddCheckBox(opt_melee_range L(not_in_melee_range) specialization=enhancement)
AddCheckBox(opt_potion_agility ItemName(draenic_agility_potion) default specialization=enhancement)
AddCheckBox(opt_legendary_ring_agility ItemName(legendary_ring_agility) default specialization=enhancement)
AddCheckBox(opt_bloodlust SpellName(bloodlust) specialization=enhancement)

AddFunction EnhancementUsePotionAgility
{
	if CheckBoxOn(opt_potion_agility) and target.Classification(worldboss) Item(draenic_agility_potion usable=1)
}

AddFunction EnhancementBloodlust
{
	if CheckBoxOn(opt_bloodlust) and DebuffExpires(burst_haste_debuff any=1)
	{
		Spell(bloodlust)
		Spell(heroism)
	}
}

AddFunction EnhancementGetInMeleeRange
{
	if CheckBoxOn(opt_melee_range) and not target.InRange(primal_strike) Texture(misc_arrowlup help=L(not_in_melee_range))
}

AddFunction EnhancementInterruptActions
{
	if CheckBoxOn(opt_interrupt) and not target.IsFriend() and target.IsInterruptible()
	{
		Spell(wind_shear)
		if not target.Classification(worldboss)
		{
			Spell(arcane_torrent_mana)
			if target.InRange(quaking_palm) Spell(quaking_palm)
			Spell(war_stomp)
		}
	}
}

### actions.default

AddFunction EnhancementDefaultMainActions
{
	#berserking,if=buff.ascendance.up|!talent.ascendance.enabled|level<100
	if BuffPresent(ascendance_melee_buff) or not Talent(ascendance_talent) or Level() < 100 Spell(berserking)
	#blood_fury
	Spell(blood_fury_apsp)
	#doom_winds
	Spell(doom_winds)
	#windsong
	Spell(windsong)
	#ascendance
	if BuffExpires(ascendance_melee_buff) Spell(ascendance_melee)
	#feral_spirit
	Spell(feral_spirit)
	#fury_of_air,if=!ticking
	if not target.DebuffPresent(fury_of_air_debuff) Spell(fury_of_air)
	#frostbrand,if=talent.hailstorm.enabled&buff.frostbrand.remains<4.8
	if Talent(hailstorm_talent) and BuffRemaining(frostbrand_buff) < 4.8 Spell(frostbrand)
	#crash_lightning,if=active_enemies>=3
	if Enemies() >= 3 Spell(crash_lightning)
	#windstrike
	Spell(windstrike)
	#stormstrike
	Spell(stormstrike)
	#lightning_bolt,if=talent.overcharge.enabled&maelstrom>=60
	if Talent(overcharge_talent) and FIXME_maelstrom >= 60 Spell(lightning_bolt)
	#lava_lash,if=buff.hot_hand.react
	if BuffPresent(hot_hand_buff) Spell(lava_lash)
	#boulderfist,if=charges_fractional>=1.5
	if Charges(boulderfist count=0) >= 1.5 Spell(boulderfist)
	#earthen_spike
	Spell(earthen_spike)
	#flametongue,if=buff.flametongue.remains<4.8
	if BuffRemaining(flametongue_buff) < 4.8 Spell(flametongue)
	#crash_lightning,if=active_enemies>1|talent.crashing_storm.enabled|(pet.feral_spirit.remains>5|pet.frost_wolf.remains>5|pet.fiery_wolf.remains>5|pet.lightning_wolf.remains>5)
	if Enemies() > 1 or Talent(crashing_storm_talent) or target.DebuffRemaining(crash_lightning_debuff) > 5 or target.DebuffRemaining(crash_lightning_debuff) > 5 or target.DebuffRemaining(crash_lightning_debuff) > 5 or target.DebuffRemaining(crash_lightning_debuff) > 5 Spell(crash_lightning)
	#sundering
	Spell(sundering)
	#lava_lash,if=maelstrom>=120
	if FIXME_maelstrom >= 120 Spell(lava_lash)
	#flametongue,if=talent.boulderfist.enabled
	if Talent(boulderfist_talent) Spell(flametongue)
	#boulderfist
	Spell(boulderfist)
	#rockbiter
	Spell(rockbiter)
}

AddFunction EnhancementDefaultShortCdActions
{
	#auto_attack
	EnhancementGetInMeleeRange()
}

AddFunction EnhancementDefaultCdActions
{
	#wind_shear
	EnhancementInterruptActions()
	#bloodlust,if=target.health.pct<25|time>0.500
	if target.HealthPercent() < 25 or TimeInCombat() > 0.5 EnhancementBloodlust()
	#use_item,slot=finger2
	if CheckBoxOn(opt_legendary_ring_agility) Item(legendary_ring_agility usable=1)
	#potion,name=draenic_agility,if=target.time_to_die<=30
	if target.TimeToDie() <= 30 EnhancementUsePotionAgility()
}

### actions.precombat

AddFunction EnhancementPrecombatMainActions
{
	#lightning_shield
	Spell(lightning_shield)
}

AddFunction EnhancementPrecombatShortCdPostConditions
{
	Spell(lightning_shield)
}

AddFunction EnhancementPrecombatCdActions
{
	#flask,type=greater_draenic_agility_flask
	#food,type=buttered_sturgeon
	#snapshot_stats
	#potion,name=draenic_agility
	EnhancementUsePotionAgility()
}

AddFunction EnhancementPrecombatCdPostConditions
{
	Spell(lightning_shield)
}

### Enhancement icons.

AddCheckBox(opt_shaman_enhancement_aoe L(AOE) default specialization=enhancement)

AddIcon checkbox=!opt_shaman_enhancement_aoe enemies=1 help=shortcd specialization=enhancement
{
	unless not InCombat() and EnhancementPrecombatShortCdPostConditions()
	{
		EnhancementDefaultShortCdActions()
	}
}

AddIcon checkbox=opt_shaman_enhancement_aoe help=shortcd specialization=enhancement
{
	unless not InCombat() and EnhancementPrecombatShortCdPostConditions()
	{
		EnhancementDefaultShortCdActions()
	}
}

AddIcon enemies=1 help=main specialization=enhancement
{
	if not InCombat() EnhancementPrecombatMainActions()
	EnhancementDefaultMainActions()
}

AddIcon checkbox=opt_shaman_enhancement_aoe help=aoe specialization=enhancement
{
	if not InCombat() EnhancementPrecombatMainActions()
	EnhancementDefaultMainActions()
}

AddIcon checkbox=!opt_shaman_enhancement_aoe enemies=1 help=cd specialization=enhancement
{
	if not InCombat() EnhancementPrecombatCdActions()
	unless not InCombat() and EnhancementPrecombatCdPostConditions()
	{
		EnhancementDefaultCdActions()
	}
}

AddIcon checkbox=opt_shaman_enhancement_aoe help=cd specialization=enhancement
{
	if not InCombat() EnhancementPrecombatCdActions()
	unless not InCombat() and EnhancementPrecombatCdPostConditions()
	{
		EnhancementDefaultCdActions()
	}
}

### Required symbols
# arcane_torrent_mana
# ascendance_melee
# ascendance_melee_buff
# ascendance_talent
# berserking
# blood_fury_apsp
# bloodlust
# boulderfist
# boulderfist_talent
# crash_lightning
# crash_lightning_debuff
# crashing_storm_talent
# doom_winds
# draenic_agility_potion
# earthen_spike
# feral_spirit
# flametongue
# flametongue_buff
# frostbrand
# frostbrand_buff
# fury_of_air
# fury_of_air_debuff
# hailstorm_talent
# heroism
# hot_hand_buff
# lava_lash
# legendary_ring_agility
# lightning_bolt
# lightning_shield
# overcharge_talent
# primal_strike
# quaking_palm
# rockbiter
# stormstrike
# sundering
# war_stomp
# wind_shear
# windsong
# windstrike
]]
	OvaleScripts:RegisterScript("SHAMAN", "enhancement", name, desc, code, "script")
end
