﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing.Drawing2D;
using IMLibrary.Controls;
using System.Drawing;

namespace IMLibrary.Controls
{ 
    public class PanelCircle : Panel
    {
        public PanelCircle()
            : base()
        {
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            base.OnPaint(e);

            Graphics g = e.Graphics;
            g.SmoothingMode = SmoothingMode.AntiAlias;
            using (GraphicsPath path = CreatePath(
                ClientRectangle,
                8,
                true))
            {
                g.FillPath(Brushes.White, path);
                using (Pen pen = new Pen(Color.AntiqueWhite))
                {
                    g.DrawPath(pen, path);
                }
            }
        }

        private GraphicsPath CreatePath(Rectangle rect, int radius, bool correction)
        {
            GraphicsPath path = new GraphicsPath();
            int radiusCorrection = correction ? 1 : 0;

            path.AddArc(rect.X, rect.Y, radius, radius, 180, 90);
            path.AddArc(
                rect.Right - radius - radiusCorrection,
                rect.Y,
                radius,
                radius,
                270,
                90);
            path.AddArc(
                rect.Right - radius - radiusCorrection,
                rect.Bottom - radius - radiusCorrection,
                radius,
                radius, 0, 90);
            path.AddArc(
                rect.X,
                rect.Bottom - radius - radiusCorrection,
                radius,
                radius,
                90,
                90);
            path.CloseFigure();
            return path;
        }
    }
}
