using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.Design.Serialization;
using System.Reflection;
using System.Text;

namespace IMLibrary.Controls.Toolbox
{
    partial class Toolbox
    {
        internal class ItemConverter : TypeConverter
        {
            public override bool CanConvertTo(ITypeDescriptorContext context, System.Type destinationType)
            {
                if (destinationType == typeof(InstanceDescriptor))
                {
                    return true;
                }
                return base.CanConvertTo(context, destinationType);
            }

            public override object ConvertTo(ITypeDescriptorContext context, System.Globalization.CultureInfo culture, object value, Type destinationType)
            {
                if (destinationType == null)
                {
                    throw new ArgumentNullException("destinationType");
                }
                if ((destinationType != typeof(InstanceDescriptor)) || !(value is Item))
                {
                    goto Label_ReturnBase;
                }

                Item item = (Item)value;
                ConstructorInfo ci = typeof(Item).GetConstructor(new Type[0]);
                return new InstanceDescriptor(ci, new object[0], false);

            Label_ReturnBase:
                return base.ConvertTo(context, culture, value, destinationType);
            }
        }
    }
}
