using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.Design.Serialization;
using System.Reflection;
using System.Text;


namespace IMLibrary.Controls.Toolbox 
{
    partial class Toolbox
    {
        internal class TabConverter : ExpandableObjectConverter
        {
            public override bool CanConvertTo(ITypeDescriptorContext context, System.Type destinationType)
            {
                if (destinationType == Toolbox._instanceDescriptorType)
                {
                    return true;
                }
                return base.CanConvertTo(context, destinationType);
            }

            public override object ConvertTo(ITypeDescriptorContext context, System.Globalization.CultureInfo culture, object value, Type destinationType)
            {
                if (destinationType == null)
                {
                    throw new ArgumentNullException("destinationType");
                }
                if ((destinationType != Toolbox._instanceDescriptorType) || !(value is Tab))
                {
                    goto Label_ReturnBase;
                }

                Tab tab = (Tab)value;
                ConstructorInfo ci = typeof(Tab).GetConstructor(new Type[0]);
                return new InstanceDescriptor(ci, new object[0], false);               

            Label_ReturnBase:
                return base.ConvertTo(context, culture, value, destinationType);
            }
        }
    }
}
