using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.Design.Serialization;
using System.Reflection;
using System.Text;

namespace IMLibrary.Controls.Toolbox
{
    partial class Toolbox
    {
        private static Type _instanceDescriptorType = typeof(InstanceDescriptor);
        internal class ToolboxConverter : TypeConverter
        {
            public override bool CanConvertTo(ITypeDescriptorContext context, System.Type destinationType)
            {
                if (destinationType == Toolbox._instanceDescriptorType)
                {
                    return true;
                }
                return base.CanConvertTo(context, destinationType);
            }

            public override object ConvertTo(ITypeDescriptorContext context, System.Globalization.CultureInfo culture, object value, Type destinationType)
            {
                if (destinationType == null)
                {
                    throw new ArgumentNullException("destinationType");
                }
                if ((destinationType != Toolbox._instanceDescriptorType) || !(value is Toolbox))
                {
                    goto Label_ReturnBase;
                }

                Toolbox toolbox = (Toolbox)value;
                Type toolboxType = toolbox.GetType();
                ConstructorInfo ci = toolboxType.GetConstructor(new Type[] { typeof(bool) });
                if (ci != null)
                {
                    bool createGeneral = false;
                    if (toolbox.Site != null && toolbox.Site.DesignMode)
                        createGeneral = toolbox.CreateGeneralCategory;
                    return new InstanceDescriptor(ci, new object[] { createGeneral }, false);
                }
                else
                {
                    ci = toolboxType.GetConstructor(new Type[0]);
                    return new InstanceDescriptor(ci, new object[0]);
                }

            Label_ReturnBase:
                return base.ConvertTo(context, culture, value, destinationType);
            }
        }
    }
}
