using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

namespace IMLibrary.Controls.Toolbox
{
    /// <summary>
    /// Provides data for the <see cref="Toolbox.SelectItem"/> event.
    /// </summary>
    public class ItemSelectionEventArgs : EventArgs
    {
        private Toolbox.Item _item;

        /// <summary>
        /// Initializes a new instance of the <see cref="ItemSelectionEventArgs"/> class using the specified <see cref="Toolbox.Item">item</see> object.
        /// </summary>
        /// <param name="item">The <see cref="Toolbox.Item">item</see> that was selected.</param>
        public ItemSelectionEventArgs(Toolbox.Item item)
        {
            if (item == null)
                throw new ArgumentNullException("item");

            _item = item;
        }

        /// <summary>
        /// Gets the <see cref="Toolbox.Item">item</see> that was selected.
        /// </summary>
        public Toolbox.Item Item
        {
            [DebuggerStepThrough]
            get { return _item; }
        }
    }
}
