using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

namespace IMLibrary.Controls.Toolbox
{
    /// <summary>
    /// Provides data for the <see cref="Toolbox.Tab.Toggle">Toggle</see> and <see cref="Toolbox.Tab.SelectedChanged">SelectedChanged</see> events on the <see cref="Toolbox.Tab"/>.
    /// </summary>
    public class TabEventArgs : EventArgs
    {
        private Toolbox.Tab _tab;
        /// <summary>
        /// Initializes a new instance of the <see cref="TabEventArgs"/> class.
        /// </summary>
        /// <param name="tab">A <see cref="Toolbox.Tab">Tab</see> object on which an event is raised.</param>
        public TabEventArgs(Toolbox.Tab tab)
        {
            if (tab == null)
                throw new ArgumentNullException("tab");

            _tab = tab;
        }

        /// <summary>
        /// Gets a <see cref="Toolbox.Tab">Tab</see> object on which an event is raised.
        /// </summary>
        public Toolbox.Tab Tab
        {
            [DebuggerStepThrough]
            get { return _tab; }
        }
    }
}
