using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Text;

namespace IMLibrary.Controls.Toolbox
{
    partial class Toolbox
    {
        /// <summary>
        /// Contains information about an area of a <see cref="Toolbox"/> control. 
        /// </summary>
        public sealed class HitTestInfo
        {
            private HitArea _hitArea;
            private Point _hitPoint;
            private IToolboxObject _hitTool;

            internal HitTestInfo(Point location) : this(location, HitArea.None, null)
            {
            }

            internal HitTestInfo(Point location, HitArea area, IToolboxObject tool)
            {
                _hitPoint = location;
                _hitArea = area;
                _hitTool = tool;
            }

            /// <summary>
            /// Gets the <see cref="Toolbox.HitArea"/> that represents the area of the toolbox evaluated by the hit-test operation.
            /// </summary>
            public HitArea HitArea
            {
                [DebuggerStepThrough]
                get { return _hitArea; }
                [DebuggerStepThrough]
                internal set { _hitArea = value; }
            }

            /// <summary>
            /// Gets the point that was hit-tested.
            /// </summary>
            public Point Location
            {
                [DebuggerStepThrough]
                get { return _hitPoint; }
            }

            /// <summary>
            /// Gets the <see cref="Tab"/> or the <see cref="Item"/> object that was hit if any.
            /// </summary>
            public IToolboxObject Tool
            {
                [DebuggerStepThrough]
                get { return _hitTool; }
                [DebuggerStepThrough]
                internal set { _hitTool = value; }
            }
        }
    }
}
