using System;
using System.Collections.Generic;
using System.Text;

namespace IMLibrary.Controls.Toolbox
{
    partial class Toolbox
    {
        internal class ToolboxItemsTab : Tab
        {
            private ItemCollection _items;

            public ToolboxItemsTab(ItemCollection items)
            {
                _items = items;

                this.Text = "Toolbox Items";
                this.AllowDelete = false;
                this.Owner = items.Owner;
            }

            public override ItemCollection Items
            {
                get
                {
                    return _items;
                }
            }

            public override bool Visible
            {
                get
                {
                    foreach (Item item in this.Items)
                    {
                        if (item.Visible)
                            return true;
                    }
                    return false;
                }
                set
                {
                }
            }
        }
    }
}
