﻿// The MIT License (MIT)
// Copyright (c) 2014 Nicolas Kogler

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.

using System;
using System.Text;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.ComponentModel;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;
using System.Runtime.InteropServices;

namespace IMLibrary.Controls.Win8form
{
    sealed class SharpHelper
    {
        private SharpHelper() : base() { }

        public const int WM_NOTHING = 0x0;
        public const int WM_NCHITTEST = 0x84;
        public const int WM_NCACTIVATE = 0x86;
        public const int WM_SYSCOMMAND = 0x112;
        public const int WM_GETSYSMENU = 0x313;
        public const int WM_ENTERMENULOOP = 0x211;
        public const int WM_EXITMENULOOP = 0x212;

        public const int WM_NCLBUTTONDOWN = 0xA1;
        public const int HT_CAPTION = 0x2;
        public const int WM_NCCALCSIZE = 0x83;

        /// <summary>
        /// Indicates which button on the controlbox
        /// is beeing mouse-overed. Add another value
        /// to handle custom buttons in the paint method.
        /// </summary>
        public enum SelButton
        {
            BTN_NONE,
            BTN_CLOSE,
            BTN_MAX,
            BTN_MIN
        }

        /// <summary>
        /// Messages that are sent to WndProc, for example
        /// to move, maximize or minimize the window.
        /// </summary>
        public enum SystemCmd
        {
            CMD_SIZE = 0xF000,
            CMD_SEPA = 0xF00F,
            CMD_MOVE = 0xF010,
            CMD_MINI = 0xF020,
            CMD_MAXI = 0xF030,
            CMD_NEXT = 0xF040,
            CMD_PREV = 0xF050,
            CMD_CLOSE = 0xF060,
            CMD_VSCROLL = 0xF070,
            CMD_HSCROLL = 0xF080,
            CMD_MOUSECM = 0xF090,
            CMD_KEYCM = 0xF100,
            CMD_ARRANGE = 0xF110,
            CMD_RESTORE = 0xF120,
            CMD_TASKS = 0xF130,
            CMD_SCREEN = 0xF140,
            CMD_HOTKEY = 0xF150,
            CMD_DEFAULT = 0xF160,
            CMD_MONITOR = 0xF170,
            CMD_CONTEXT = 0xF180
        }

        /// <summary>
        /// Indicates which mouse cursor is displayed.
        /// This can for example be the "expand" cursor.
        /// </summary>
        public enum NCHitTest
        {
            HTERROR = (-2),
            HTTRANSPARENT,
            HTNOWHERE,
            HTCLIENT,
            HTCAPTION,
            HTSYSMENU,
            HTGROWBOX,
            HTMENU,
            HTHSCROLL,
            HTVSCROLL,
            HTMINBUTTON,
            HTMAXBUTTON,
            HTLEFT,
            HTRIGHT,
            HTTOP,
            HTTOPLEFT,
            HTTOPRIGHT,
            HTBOTTOM,
            HTBOTTOMLEFT,
            HTBOTTOMRIGHT,
            HTBORDER,
            HTOBJECT,
            HTCLOSE,
            HTHELP
        }

        /// <summary>
        /// Defines which mouse-actions the user has
        /// made, handles close/maximize/minimize and
        /// custom buttons
        /// </summary>
        public enum NCMouseMsg
        {
            WM_NCMOUSEMOVE = 0xA0,
            WM_NCLBUTTONDOWN = 0xA1,
            WM_NCLBUTTONUP = 0xA2,
            WM_NCLBUTTONDBLCLK = 0xA3,
            WM_NCRBUTTONDOWN = 0xA4,
            WM_NCRBUTTONUP = 0xA5,
            WM_NCRBUTTONDBLCLK = 0xA6,
            WM_NCMBUTTONDOWN = 0xA7,
            WM_NCMBUTTONUP = 0xA8,
            WM_NCMBUTTONDBLCLK = 0xA9,
            WM_NCXBUTTONDOWN = 0xAB,
            WM_NCXBUTTONUP = 0xAC,
            WM_NCXBUTTONDBLCLK = 0xAD
        }

        public static IntPtr LParamFrom(int lowword, int highword)
        {
            return (IntPtr)((highword << 16) | (lowword & 0xFFFF));
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct RECT
        {
            public int left, top, right, bottom;

            public RECT(Rectangle rc)
            {
                this.left = rc.Left;
                this.top = rc.Top;
                this.right = rc.Right;
                this.bottom = rc.Bottom;
            }

            public Rectangle ToRectangle()
            {
                return Rectangle.FromLTRB(left, top, right, bottom);
            }

        }

        [StructLayout(LayoutKind.Sequential)]
        public struct NCCALCSIZE_PARAMS
        {
            public RECT rgrc0, rgrc1, rgrc2;
            public WINDOWPOS lppos;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct WINDOWPOS
        {
            public IntPtr hWnd, hWndInsertAfter;
            public int x, y, cx, cy, flags;
        }
    }
}