﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;
using System.Data.SqlClient;

namespace IMLibrary
{
    public sealed class DBAccess
    {

        #region 配置参数
        /// <summary>
        /// 数据库类型
        /// </summary>
        public enum DBType
        {
            /// <summary>
            /// 微软SQL SERVER数据库
            /// </summary>
            SqlServer = 0,
            /// <summary>
            /// MySQL数据库
            /// </summary>
            MySQL = 1,
            /// <summary>
            /// Oracle数据库
            /// </summary>
            Oracle = 2,
        }

        /// <summary>
        /// 数据据类型
        /// </summary>
        public static DBType DBtype = DBType.MySQL;

        public static void SetMySQLConnection(string serverIP, string DBname, string userName, string password)
        {
            string conStr = string.Format("Server={0};Port={1};Database={2};Uid={3};Pwd={4};",
                serverIP, 3306, DBname, userName, password);
            IMLibrary.MySqlData.DataAccess.ConnectionString = conStr;
            IMLibrary.MySqlData.DataAccess.IniTables();
        }

        public static void SetSQLConnection(string serverIP, string DBname, string userName, string password)
        {
            string conStr = string.Format("Server={0};Initial Catalog={1};User id={2};password={3};",
                serverIP, DBname, userName, password);
            IMLibrary.SqlData.DataAccess.ConnectionString = conStr;
            IMLibrary.SqlData.DataAccess.IniTables();

        }
        #endregion

        #region 扩展
        /// <summary>
        /// 
        /// </summary>
        /// <param name="obj"></param>
        /// <param name="TableName"></param>
        /// <returns></returns>
        public static int InsertOne(object obj, string TableName)
        {
            if (DBtype == DBType.MySQL)
                return IMLibrary.MySqlData.DataAccess.InsertOne(obj, TableName);
            else if (DBtype == DBType.SqlServer)
                return IMLibrary.SqlData.DataAccess.InsertOne(obj, TableName);

            return 0;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="objs"></param>
        /// <param name="Tables"></param>
        /// <returns></returns>
        public static int InsertMore(List<object> objs, params string[] Tables)
        {
            if (DBtype == DBType.MySQL)
                return IMLibrary.MySqlData.DataAccess.InsertMore(objs, Tables);
            else if (DBtype == DBType.SqlServer)
                return IMLibrary.SqlData.DataAccess.InsertMore(objs, Tables);
            return 0;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="obj"></param>
        /// <param name="TableName"></param>
        /// <param name="ConditionField"></param>
        /// <returns></returns>
        public static int Update(object obj, string TableName, string ConditionField)
        {
            if (DBtype == DBType.MySQL)
                return IMLibrary.MySqlData.DataAccess.Update(obj, TableName, ConditionField);
            else if (DBtype == DBType.SqlServer)
                return IMLibrary.SqlData.DataAccess.Update(obj, TableName, ConditionField);
            return 0;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="objs"></param>
        /// <param name="ConditionField"></param>
        /// <param name="Tables"></param>
        /// <returns></returns>
        public static int UpdateMore(List<object> objs, string ConditionField, params string[] Tables)
        {
            if (DBtype == DBType.MySQL)
                return IMLibrary.MySqlData.DataAccess.UpdateMore(objs, ConditionField, Tables);
            else if (DBtype == DBType.SqlServer)
                return IMLibrary.SqlData.DataAccess.UpdateMore(objs, ConditionField, Tables);
            return 0;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="TableName"></param>
        /// <param name="ConditionString"></param>
        /// <returns></returns>
        public static int Delete(string TableName, string ConditionString)
        {
            if (DBtype == DBType.MySQL)
                return IMLibrary.MySqlData.DataAccess.Delete(TableName, ConditionString);
            else if (DBtype == DBType.SqlServer)
                return IMLibrary.SqlData.DataAccess.Delete(TableName, ConditionString);
            return 0;
        }

        /// <summary>
        /// 根据条件和表查询
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="TableName"></param>
        /// <param name="ConditionString"></param>
        /// <returns></returns>
        public static List<T> SelectCondition<T>(string TableName, string ConditionString)
        {
            if (DBtype == DBType.MySQL)
                return IMLibrary.MySqlData.DataAccess.Select<T>(TableName, ConditionString);
            else if (DBtype == DBType.SqlServer)
                return IMLibrary.SqlData.DataAccess.Select<T>(TableName, ConditionString);
            return null;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="sql"></param>
        /// <param name="mysql"></param>
        /// <returns></returns>
        public static List<T> Select<T>(string sql, string mysql)
        {
            if (DBtype == DBType.MySQL)
                return IMLibrary.MySqlData.DataAccess.Select<T>(mysql);
            else if (DBtype == DBType.SqlServer)
                return IMLibrary.SqlData.DataAccess.Select<T>(sql);
            return null;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="sql"></param>
        /// <returns></returns>
        public static List<T> Select<T>(string sql)
        {
            return Select<T>(sql, sql);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="sql"></param>
        /// <param name="mysql"></param>
        /// <returns></returns>
        public static int ExecSql(string sql, string mysql)
        {
            if (DBtype == DBType.MySQL)
                return IMLibrary.MySqlData.DataAccess.ExecSql(mysql);
            else if (DBtype == DBType.SqlServer)
                return IMLibrary.SqlData.DataAccess.ExecSql(sql);
            return 0;
        }
        /// <summary>
        /// 
        /// </summary>
        /// <param name="sql"></param>
        /// <returns></returns>
        public static int ExecSql(string sql)
        {
            return ExecSql(sql, sql);
        }
        #endregion

    }
}
