﻿using System;
using System.Collections.Generic;
using System.Data;
using MySql.Data;
using MySql.Data.MySqlClient;
using System.Runtime.InteropServices;
using System.Xml;
using System.Configuration;

namespace IMLibrary.MySqlData
{
    /// <summary>
    //  扩展(依赖AutoMapper.dll)
    /// </summary>
    public sealed partial class DataAccess
    {
        #region 静态方法
        /// <summary>
        /// 
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="spName"></param>
        /// <param name="parameterValues"></param>
        /// <returns></returns>
        public static List<T> GetObjectsByProc<T>(string spName, params object[] parameterValues)
        {
            using (MySqlDataReader reader = GetReaderByProc(spName, parameterValues))
            {
                //return AutoMapper.Mapper.DynamicMap<List<T>>(reader).FirstOrDefault();//获得第一条
                return AutoMapper.Mapper.DynamicMap<List<T>>(reader);
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="commandText"></param>
        /// <param name="commandParameters"></param>
        /// <returns></returns>
        public static List<T> GetObjectsBySql<T>(string commandText, params MySqlParameter[] commandParameters)
        {
            using (MySqlDataReader reader = GetReaderBySql(commandText,commandParameters  ))
            {
                //return AutoMapper.Mapper.DynamicMap<List<T>>(reader).FirstOrDefault();//获得第一条
                return AutoMapper.Mapper.DynamicMap<List<T>>(reader);
            }
        }

        #endregion
    }


}

