﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using STSdb4.Database;

namespace Ourmsg.Server
{
    /// <summary>
    /// 注册用户放号服务
    /// </summary>
    public sealed class CacheRegisterUser
    {
        /// <summary>
        /// 
        /// </summary>
        private static string DBName = "UnusedUsers.stsdb4";
        /// <summary>
        /// 放号
        /// </summary>
        /// <param name="StartID"></param>
        /// <param name="EndID"></param>
        public static void WriteNumber(UInt32 StartID, UInt32 EndID)
        {
            using (IStorageEngine engine = STSdb.FromFile(DBName))
            {
                var table = engine.OpenXTable<UInt32, UInt32>("UnusedUsers");
                for (UInt32 i = StartID; i <= EndID; i++)
                    table[i] = i;
                engine.Commit();
            }
        }


        /// <summary>
        /// 获取一个未使用的帐号
        /// </summary>
        /// <returns></returns>
        public static UInt32 GetUnusedID()
        {
            UInt32  ID = 0;
            using (IStorageEngine engine = STSdb.FromFile(DBName))
            {
                var table = engine.OpenXTable<UInt32, UInt32>("UnusedUsers");
                foreach (var id in table)
                {
                    ID = id.Value ;
                    break;
                }
                table.Delete(ID);
                engine.Commit();
            }
            return ID;
        }

    }
}
