﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using STSdb4.Database;

namespace Ourmsg.Server
{ 
    /// <summary>
    /// 离线消息服务器
    /// </summary>
    public class OfflineMessageServer
    {

        public OfflineMessageServer(int port = 2005)
        {
            Port = port;
        }

        int Port = 2005;
        IStorageEngine engine=null ;
        STSdb4.Remote.StorageEngineServer server = null;

        /// <summary>
        /// 启动服务
        /// </summary>
        public void Start()
        {
            if (engine == null)
                engine = STSdb.FromFile("OfflineMessages.stsdb4");
            if (server == null)
                server = STSdb.CreateServer(engine, Port);
            server.Start();
        }

        /// <summary>
        /// 停止服务
        /// </summary>
        public void Stop()
        { 
            if (server != null)
            {
                server.Stop();
                server = null;
            }
            if (engine != null)
            {
                engine.Commit();
                engine.Close();
                engine = null;
            }
        }
    }
}
