﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using IMLibrary.WS;
using IMLibrary.WS.Server;
using IMLibrary.WS.Net;

namespace Ourmsg.Server
{
    #region WebSocketSession
    public class WebSocketSession : WebSocketBehavior
    {
        public WebSocketSession(WebSocketService server)
        {
            Server = server;
        }
        WebSocketService Server;
        protected override void OnMessage(MessageEventArgs e)
        {
            base.OnMessage(e);
            if (Server != null)
                Server.OnMessage(this, e);
        }

        protected override void OnClose(CloseEventArgs e)
        {
            if (Server != null)
                Server.OnClose(this, e);
            base.OnClose(e);
        }

        protected override void OnOpen()
        {
            if (Server != null)
                Server.OnOpen(this);

            base.OnOpen();
        }

        protected override void OnError(ErrorEventArgs e)
        {
            if (Server != null)
                Server.OnError(this, e);
            base.OnError(e);
        }
    }
    #endregion

    #region WebSocketServer
    public class WebSocketService
    {
        public string  Path = "/MyServer";
        /// <summary>
        /// Websocket 服务器
        /// </summary>
        public WebSocketServer WSServer;
        /// <summary>
        /// 获取所有Sessions
        /// </summary>
        public WebSocketSessionManager Sessions
        {
            get
            {
                if (WSServer != null)
                    return WSServer.WebSocketServices[Path].Sessions;
                else
                    return null;
            }
        }
        public virtual void OnClose(WebSocketSession session, CloseEventArgs e)
        {
        }

        public virtual void OnError(WebSocketSession session, ErrorEventArgs e)
        {
        }

        public virtual void OnMessage(WebSocketSession session, MessageEventArgs e)
        {
        }

        public virtual void OnOpen(WebSocketSession session)
        {
        }
    }
    #endregion

}
