﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Ourmsg.Enum
{ 
    
    /// <summary>
    /// 通信协议命令类型
    /// </summary>
    public enum CommandType : byte
    {
        /// <summary>
        /// 无任何操作
        /// </summary>
        None=0,
        /// <summary>
        /// 用户改变状态
        /// </summary>
        Presence = 1,
        /// <summary>
        /// 用户成功登录,设置状态
        /// </summary>
        UserLogined = 2,
        #region 请求编辑(添加、删除、更新)、查询资料部分
        /// <summary>
        /// 注册新用户
        /// </summary>
        UserRegister=4,
        /// <summary>
        /// 用户登录
        /// </summary>
        Auth=5,
        /// <summary>
        /// 用户登录密码错误或帐号不存在
        /// </summary>
        AuthError=6,
        /// <summary>
        /// 用户在别处登录
        /// </summary>
        ElseLogin=7,
        /// <summary>
        /// 编辑头像
        /// </summary>
        Face=7,
        /// <summary>
        /// 上传、下载、删除离线文件
        /// </summary>
        OfflineFile,
        /// <summary>
        /// 上传、下载、删除图片文件（用于聊天表情等功能）
        /// </summary>
        ExpressionImage,
        /// <summary>
        /// 用户好友基本资料
        /// </summary>
        FriendBaseData,
        /// <summary>
        /// 用户分组资料
        /// </summary>
        GroupData,
        /// <summary>
        /// 用户资料
        /// </summary>
        FriendData,
        /// <summary>
        /// 用户群基本资料
        /// </summary>
        RoomBaseData,       
        /// <summary>
        /// 用户群分组信息
        /// </summary>
        RoomGroups,
        /// <summary>
        /// 用户黑名单
        /// </summary>
        Blacklists,
        /// <summary>
        /// 获得所有好友在线状态
        /// </summary>
        GetFriendPresences,
        /// <summary>
        /// 一位好友在线状态
        /// </summary>
        //FriendPresence,
        /// <summary>
        /// 多位好友在线状态
        /// </summary>
        FriendPresences,
        /// <summary>
        /// 群中一位好友在线状态
        /// </summary>
        //RoomFriendPresence,
        /// <summary>
        /// 群中多位好友在线状态
        /// </summary>
        RoomFriendPresences,
        /// <summary>
        /// 用户消息
        /// </summary>
        UserMessage, 
        /// <summary>
        /// 群消息
        /// </summary>
        RoomMessage, 
        /// <summary>
        /// 创建群
        /// </summary>
        CreateRoom,
        /// <summary>
        /// 更新群基本信息
        /// </summary>
        SetRoomBaseInfo,
        /// <summary>
        /// 删除一个群用户
        /// </summary>
        DelRoomUser, 
        /// <summary>
        /// 设置群管理员
        /// </summary>
        SetRoomManger,
        /// <summary>
        /// 设置群用户名片
        /// </summary>
        SetRoomUserCard,
        /// <summary>
        /// 邀请加群
        /// </summary>
        InviteAddRoom,
        /// <summary>
        /// 请求加群
        /// </summary>
        RequestAddRoom,
        /// <summary>
        /// 请求添加好友
        /// </summary>
        RequestAddFriend,
        /// <summary>
        /// 回应请求添加好友
        /// </summary>
        ResponsesAddFriend,
        /// <summary>
        /// 添加好友成功
        /// </summary>
        AddFriendSuccess,
        /// <summary>
        /// 回应请求添加群
        /// </summary>
        ResponsesAddRoom,
        /// <summary>
        /// 回应邀请添加群
        /// </summary>
        ResponsesInviteAddRoom,
        /// <summary>
        /// 删除好友
        /// </summary>
        DelFriend,
        /// <summary>
        /// 退出群
        /// </summary>
        QuitRoom,
        /// <summary>
        /// 解散(删除)群
        /// </summary>
        DelRoom,
        /// <summary>
        /// 获得群用户资料
        /// </summary>
        GetRoomUserData,
        /// <summary>
        /// 查询用户或群资料
        /// </summary>
        Query,
        /// <summary>
        /// 用户分组信息操作
        /// </summary>
        UserGroupInfoOperation, 
        /// <summary>
        /// 用户群分组信息操作
        /// </summary>
        RoomGroupInfoOperation, 
        #endregion

        /// <summary>
        /// 错误类型
        /// </summary>
        Error = 255,
    }
   
}
