﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using IM.P;
using IM.Cache;

namespace IMLibrary 
{
    /// <summary>
    /// 协议转换器
    /// </summary>
    public sealed class JsonFactorys
    {
        public static JsonSerializerSettings settings;

        #region 从json字符串序列化为对像
        /// <summary>
        /// 从json字符串序列化为对像
        /// </summary>
        /// <param name="jsonString"></param>
        /// <returns></returns>
        public static object GetObject(string jsonString)
        {
            try
            {
                return JsonConvert.DeserializeObject(jsonString, settings);
            }
            catch { }
            return null;
        }
        #endregion

        #region 获得服务器注册协议类
        /// <summary>
        /// 获得服务器注册协议类
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static ServerInfo GetServerInfo(string data)
        {
            try
            {
                return JsonConvert.DeserializeObject<ServerInfo>(data);
            }
            catch { return null; }
        }
        #endregion

        #region 获得认证类
        /// <summary>
        /// 获得认证类
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static Auth GetAuth(string data)
        {
            try
            {
                return JsonConvert.DeserializeObject<Auth>(data);
            }
            catch { return null; }
        }
        #endregion

        #region 获得用户在线状态

        /// <summary>
        /// 获得用户在线状态
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static Presence GetPresence(string data)
        {
            try
            {
                return JsonConvert.DeserializeObject<Presence>(data);
            }
            catch { return null; }
        }
        #endregion

        #region 获得用户服务器在线状态

        /// <summary>
        /// 获得用户服务器在线状态
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static UserStatus GetUserStatus(string data)
        {
            try
            {
                return JsonConvert.DeserializeObject<UserStatus>(data);
            }
            catch { return null; }
        }
        #endregion

        #region 获得用户分组信息列表
        /// <summary>
        /// 获得用户分组信息列表
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<Group> GetUserGroups(string data)
        {
            try
            {
                return JsonConvert.DeserializeObject<List<Group>>(data);
            }
            catch { return null; }
        }
        #endregion

        #region 获得用户好友基本信息列表
        /// <summary>
        /// 获得用户好友基本信息列表
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<UserFriendBaseInfo> GetUserFriendBaseInfos(string data)
        {
            try
            {
                return JsonConvert.DeserializeObject<List<UserFriendBaseInfo>>(data);
            }
            catch { return null; }
        }
        #endregion

        #region 获得用户群基本信息列表
        /// <summary>
        /// 获得用户群基本信息列表
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<UserRoomBaseInfo> GetUserRoomBaseInfos(string data)
        {
            try
            {
                return JsonConvert.DeserializeObject<List<UserRoomBaseInfo>>(data);
            }
            catch { return null; }
        }
        #endregion

        #region 获得用户群分组信息列表
        /// <summary>
        /// 获得用户群分组信息列表
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<UserRoomGroup> GetUserRoomGroups(string data)
        {
            try
            {
                return JsonConvert.DeserializeObject<List<UserRoomGroup>>(data);
            }
            catch { return null; }
        }
        #endregion

        #region 获得用户黑名单信息列表
        /// <summary>
        /// 获得用户黑名单信息列表
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<UserBlacklist> GetUserBlacklists(string data)
        {
            try
            {
                return JsonConvert.DeserializeObject<List<UserBlacklist>>(data);
            }
            catch { return null; }
        }
        #endregion

        #region 获得用户好友帐号列表
        /// <summary>
        /// 获得用户好友帐号列表
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<UInt32> GetUserFriendList(string data)
        {
            try
            {
                return JsonConvert.DeserializeObject<List<UInt32>>(data);
            }
            catch { return null; }
        }
        #endregion

        #region 获得用户一位好友在线状态列表
        /// <summary>
        /// 获得用户一位好友在线状态列表
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static Presence GetUserFriendPresence(string data)
        {
            try
            {
                return JsonConvert.DeserializeObject<Presence>(data);
            }
            catch { return null; }
        }
        #endregion

        #region 获得用户多位好友在线状态列表
        /// <summary>
        /// 获得用户多位好友在线状态列表
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<Presence> GetUserFriendPresences(string data)
        {
            try
            {
                return JsonConvert.DeserializeObject<List<Presence>>(data);
            }
            catch { return null; }
        }
        #endregion

        #region 获得用户多条消息列表
        /// <summary>
        /// 获得用户多条消息列表
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static List<Message> GetMessages(string data)
        {
            try
            {
                return JsonConvert.DeserializeObject<List<Message>>(data);
            }
            catch { return null; }
        }
        #endregion

        #region 获得用户或群消息列表
        /// <summary>
        /// 获得用户或群消息列表
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static Message GetMessage(string data)
        {
            try
            {
                return JsonConvert.DeserializeObject<Message>(data);
            }
            catch { return null; }
        }
        #endregion

        #region 加工数据
        /// <summary>
        /// 加工数据
        /// </summary>
        /// <param name="obj"></param>
        /// <returns></returns>
        public static string ConvertToStrings(object obj)
        {
            if (settings == null)
            {
                settings = new JsonSerializerSettings();
                settings.NullValueHandling = NullValueHandling.Ignore;
                settings.DefaultValueHandling = DefaultValueHandling.Ignore;
            }
            return JsonConvert.SerializeObject(obj);
        }

        /// <summary>
        /// 加工数据
        /// </summary>
        /// <param name="obj"></param>
        /// <returns></returns>
        public static byte[] ConvertToArray(object obj)
        {
            if (settings == null)
            {
                settings = new JsonSerializerSettings();
                settings.NullValueHandling = NullValueHandling.Ignore;
                settings.DefaultValueHandling = DefaultValueHandling.Ignore;
            }
            return Encoding.UTF8.GetBytes(JsonConvert.SerializeObject(obj, Formatting.None, settings));
        }

        public static byte[] ConvertToArray(IM.Enum.ServerCommandType cmd, object obj)
        {
            if (settings == null)
            {
                settings = new JsonSerializerSettings();
                settings.NullValueHandling = NullValueHandling.Ignore;
                settings.DefaultValueHandling = DefaultValueHandling.Ignore;
            }

            byte[] data = new byte[1] { (byte)cmd };
            List<byte> result = new List<byte>();
            result.AddRange(data);
            result.AddRange(Encoding.UTF8.GetBytes(JsonConvert.SerializeObject(obj, Formatting.None, settings)));
            return result.ToArray();
        }
        #endregion 

        #region 合并多个字节数组
        /// <summary>
        /// 合并多个字节数组
        /// </summary>
        /// <param name="arrays"></param>
        /// <returns></returns>
        public static IEnumerable<byte> Combine(params byte[][] arrays)
        {
            foreach (byte[] a in arrays)
                foreach (byte b in a)
                    yield return b;
        }
        #endregion
          
        #region 消息处理
        /// <summary>
        /// 设置消息字体颜色
        /// </summary>
        /// <param name="value"></param>
        /// <param name="Msg"></param>
        public static void SetColor(System.Drawing.Color value, Message Msg)
        {
            Msg.FontColor = value.ToArgb();
        }

        /// <summary>
        /// 获取消息字体颜色
        /// </summary>
        /// <param name="Msg"></param>
        /// <returns></returns>
        public static System.Drawing.Color GetColor(Message Msg)
        {
            if (Msg.FontColor == 0) Msg.FontColor = 16777216;
            return System.Drawing.Color.FromArgb(Msg.FontColor);
        }
        /// <summary>
        /// 设置消息字体
        /// </summary>
        /// <param name="value"></param>
        /// <param name="Msg"></param>
        public static void SetFont(System.Drawing.Font value, Message Msg)
        { 
            //if (this.FontSize <= 0) this.FontSize = 9f;
            Msg.FontName = value.Name;//获得字体名称
            Msg.FontSize = value.Size;//字体大小
            Msg.FontBold = value.Bold;//是否粗体
            Msg.FontItalic = value.Italic;//是否斜体
            Msg.FontStrikeout = value.Strikeout;//是否删除线
            Msg.FontUnderline = value.Underline;//是否下划线 
        }
        /// <summary>
        /// 获得消息字体
        /// </summary>
        /// <param name="Msg"></param>
        /// <returns></returns>
        public static System.Drawing.Font GetFont(Message Msg)
        {
            if (Msg.FontSize <= 0) Msg.FontSize = 9f;
            System.Drawing.FontStyle fontStyle = new System.Drawing.FontStyle();
            if (Msg.FontBold) fontStyle = System.Drawing.FontStyle.Bold;
            if (Msg.FontItalic) fontStyle = fontStyle | System.Drawing.FontStyle.Italic;
            if (Msg.FontStrikeout) fontStyle = fontStyle | System.Drawing.FontStyle.Strikeout;
            if (Msg.FontUnderline) fontStyle = fontStyle | System.Drawing.FontStyle.Underline;
            System.Drawing.Font ft = new System.Drawing.Font(Msg.FontName, Msg.FontSize, fontStyle);
            return ft;
        }
        #endregion
    }
}
