﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Ourmsg.Enum;
using IMLibrary.Controls.Toolbox;
using P;

namespace OurMsg 
{
    public class ExRoom
    { 
        /// <summary>
        /// 群基本信息
        /// </summary>
        public RoomBaseInfo BaseInfo=new RoomBaseInfo();
        /// <summary>
        /// 群用户
        /// </summary>
        public List<RoomUser> Users = new  List<RoomUser>();

        /// <summary>
        /// Tag
        /// </summary>
        public object Tag = null;
        /// <summary>
        /// 标识是否删除
        /// </summary>
        public bool IsDel = false;
        /// <summary>
        /// 在联系人控件列表中的项
        /// </summary>
        public Toolbox.Item ToolboxItem;
        /// <summary>
        /// 聊天窗体
        /// </summary>
        public FormTalkRoom  formTalk;


        /// <summary>
        /// 添加群用户
        /// </summary>
        /// <param name="user"></param>
        public void AddUser(RoomUser user)
        {
            foreach (RoomUser u in this.Users)
                if (u.UserID == user.UserID)
                {
                    u.UserName = user.UserName;
                    u.LastTalkDate = user.LastTalkDate;
                    u.HeadID = user.HeadID;
                    u.Admin  = user.Admin ;
                    u.ShowType = user.ShowType;
                    u.UserCard = user.UserCard;
                    u.UserLevel = user.UserLevel;
                    return;
                }
            Users.Add(user);
        }

        /// <summary>
        /// 获得群用户
        /// </summary>
        /// <param name="userID"></param>
        /// <returns></returns>
        public RoomUser GetUser(UInt32 userID)
        {
            foreach (var u in Users.ToArray())
                if (userID == u.UserID)
                    return u;
            return null;
        }

        /// <summary>
        /// 删除群用户
        /// </summary>
        /// <param name="userID"></param>
        /// <returns></returns>
        public bool DelUser(UInt32 userID)
        {
            foreach (var u in Users.ToArray())
                if (userID == u.UserID)
                    lock (Users)
                    {
                        Users.Remove(u);
                        return true;
                    }
            return false;
        }
    }
}
