﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace OurMsg
{
        /// <summary>
    /// 消息类型
    /// </summary>
    public enum MsgType : byte
    {
        /// <summary>
        /// 用户消息
        /// </summary>
        userMsg=0,
        /// <summary>
        /// 群消息
        /// </summary>
        roomMsg=1,
        /// <summary>
        /// 通知消息
        /// </summary>
        noticeMsg=2,
        /// <summary>
        /// 请求添加好友
        /// </summary>
        requestAddFriend,
        /// <summary>
        /// 请求添加群
        /// </summary>
        requestAddRoom,
        /// <summary>
        /// 邀请添加群
        /// </summary>
        inviteAddRoom,
        /// <summary>
        /// 拒绝添加好友
        /// </summary>
        refuseAddFriend,
        /// <summary>
        /// 拒绝添加群
        /// </summary>
        refuseAddRoom,
        /// <summary>
        /// 拒绝加入群
        /// </summary>
        refuseInviteAddRoom
    }

    /// <summary>
    /// 收到的消息
    /// </summary>
    public class ReceiveMsg
    {
        /// <summary>
        /// 消息类型
        /// </summary>
        public MsgType msgType = MsgType.userMsg;
        /// <summary>
        /// 用户（群）帐号
        /// </summary>
        public uint ID;
        /// <summary>
        /// 图标
        /// </summary>
        public System.Drawing.Icon  image;
        /// <summary>
        /// 消息数
        /// </summary>
        public int msgCount;
        /// <summary>
        /// Tag属性
        /// </summary>
        public object Tag;
    }
}
