﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using IMLibrary.Controls;
using Ourmsg.Enum;
using IMLibrary;

namespace OurMsg.Controls
{
    public partial class ButtonShowType : GenericCommandLink.CommandLink
    {
        public ButtonShowType()
        {
            InitializeComponent();
            menuShowType = new MenuShowType(this);
            this.Click += (s, e) => menuShowType.Show(this, new Point(0, this.Height));
        }



        ShowType _showType = ShowType.NONE;
        /// <summary>
        /// 在线状态
        /// </summary>
        public ShowType ShowType
        {
            set
            {
                if (_showType != value)
                {
                    _showType = value;
                    onShowTypeChanged();
                }
            }
            get { return _showType; }
        }



        /// <summary>
        /// 在线状态菜单
        /// </summary>
        private MenuShowType menuShowType;

        public delegate void EventHandler(object sender, EventArgs e);
        /// <summary>
        /// 更改状态事件
        /// </summary>
        public event EventHandler ShowTypeChanged;
        private void onShowTypeChanged()
        {
            if (ShowTypeChanged != null)
                ShowTypeChanged(this, null);

        }
        /// <summary>
        /// 设置为离线状态
        /// </summary>
        public void SetShowType(ShowType showType)
        {
            this._showType =  ShowType.Offline;
            switch (showType)
            {
                case  ShowType.Offline:
                    {
                        this.Image = ShowTypeResources.imoffline;
                        this.HeaderText = "离线";
                    }
                    break;
                case ShowType.dnd:
                    {
                        this.Image = ShowTypeResources.mute;
                        this.HeaderText = "请忽打扰";
                    }
                    break;
                case ShowType.Invisible:
                    {
                        this.Image = ShowTypeResources.invisible;
                        this.HeaderText = "隐身";
                    }
                    break;
                case  ShowType.NONE:
                    {
                        this.Image = ShowTypeResources.imonline;
                        this.HeaderText = "在线";
                    }
                    break;
                case  ShowType.away:
                    {
                        this.Image = ShowTypeResources.away;
                        this.HeaderText = "离开";
                    }
                    break;
                case ShowType.xa:
                    {
                        this.Image = ShowTypeResources.busy;
                        this.HeaderText = "忙碌";
                    }
                    break;
            }
        }

        public void HideOfflineItem()
        {
            if (menuShowType != null)
                menuShowType.HideOfflineItem();
        }
    } 
}
