﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using P;


namespace OurMsg.Controls
{
    public partial class InviteMsgControl : UserControl
    {

        /// <summary>
        /// 构造函数
        /// </summary>
        /// <param name="msgType">消息类型</param>
        public InviteMsgControl(InviteMsgType msgType, P.InviteMsg msg)
        {
            InitializeComponent();
            MsgType = msgType;
            if (msgType == InviteMsgType.Room)
            {
                labelRoomTitle.Visible = true;
                linkLabelRoomInfo.Visible = true;

                labelAttachedTitle.Visible = false;
                labelAttachedMsg.Visible = false;
            }
        }

        public enum InviteMsgType
        {
            User,
            Room,
        }

        private InviteMsgType MsgType = InviteMsgType.User;

        #region 事件
        /// <summary>
        /// 发送事件代理
        /// </summary>
        /// <param name="Msg">要发送的消息</param>
        public delegate void CreateMsgEventHandler(object sender, Element Msg);
        /// <summary>
        /// 
        /// </summary>
        public event CreateMsgEventHandler CreateMsgAfter;
        /// <summary>
        /// 
        /// </summary>
        /// <param name="msg"></param>
        private void OnCreateMsgAfter(Element msg)
        {
            if (CreateMsgAfter != null)
                CreateMsgAfter(this, msg);
        }
        #endregion

   

        private void linkLabelRefuse_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {

        }

    }
}
