﻿using System;
using System.Text;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.ComponentModel;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;
using IMLibrary.Controls;
using Ourmsg.Enum;

namespace OurMsg.Controls
{
    public class MenuShowType : ContextMenuStrip
    {
        private System.Windows.Forms.ToolStripMenuItem TSItemNone = new ToolStripMenuItem();
        private System.Windows.Forms.ToolStripMenuItem TSItemAway = new ToolStripMenuItem();
        private System.Windows.Forms.ToolStripMenuItem TSItemDnd = new ToolStripMenuItem();
        private System.Windows.Forms.ToolStripMenuItem TSItemBusy = new ToolStripMenuItem();
        private System.Windows.Forms.ToolStripMenuItem TSItemInvisible = new ToolStripMenuItem();
        private System.Windows.Forms.ToolStripMenuItem TSItemOffline = new ToolStripMenuItem();
        private System.Windows.Forms.ToolStripSeparator toolStripSeparator1 = new ToolStripSeparator();

        private ButtonShowType CommandLink;

        public MenuShowType(ButtonShowType control, bool IsHideOfflineItem = false)
            : base()
        {
            CommandLink = control;
            this.ImageScalingSize = new Size(11, 11);
            this.Renderer = new IMLibrary.Controls.Win8form.SharpMenuRenderer();
            // 
            // TSItemNone
            // 
            this.TSItemNone.Name = "TSItemNone";
            this.TSItemNone.Tag = ShowType.NONE;
            this.TSItemNone.Size = new System.Drawing.Size(152, 22);
            this.TSItemNone.Text = "在线";
            this.TSItemNone.Image = ShowTypeResources.imonline;
            this.TSItemNone.Click += TSItem_Click;
            // 
            // TSItemBusy
            // 
            this.TSItemBusy.Name = "TSItemBusy";
            this.TSItemBusy.Tag = ShowType.xa;
            this.TSItemBusy.Size = new System.Drawing.Size(152, 22);
            this.TSItemBusy.Text = "忙碌";
            this.TSItemBusy.Image = ShowTypeResources.busy;
            this.TSItemBusy.Click += TSItem_Click;
            // 
            // TSItemDnd
            // 
            this.TSItemDnd.Name = "TSItemDnd";
            this.TSItemDnd.Tag = ShowType.dnd;
            this.TSItemDnd.Size = new System.Drawing.Size(152, 22);
            this.TSItemDnd.Text = "请匆打扰";
            this.TSItemDnd.Image = ShowTypeResources.mute;
            this.TSItemDnd.Click += TSItem_Click;

            // 
            // TSItemAway
            // 
            this.TSItemAway.Name = "TSItemAway";
            this.TSItemAway.Tag = ShowType.away;
            this.TSItemAway.Size = new System.Drawing.Size(152, 22);
            this.TSItemAway.Text = "离开";
            this.TSItemAway.Image = ShowTypeResources.away;
            this.TSItemAway.Click += TSItem_Click;

            // 
            // TSItemInvisible
            // 
            this.TSItemInvisible.Name = "TSItemInvisible";
            this.TSItemInvisible.Tag = ShowType.Invisible;
            this.TSItemInvisible.Size = new System.Drawing.Size(152, 22);
            this.TSItemInvisible.Text = "隐身";
            this.TSItemInvisible.Image = ShowTypeResources.invisible;
            this.TSItemInvisible.Click += TSItem_Click;

            // 
            // toolStripSeparator1
            // 
            this.toolStripSeparator1.Name = "toolStripSeparator1";
            this.toolStripSeparator1.Size = new System.Drawing.Size(149, 6);
            // 
            // TSItemOffline
            // 
            this.TSItemOffline.Name = "TSItemOffline";
            this.TSItemOffline.Tag = ShowType.Offline;
            this.TSItemOffline.Size = new System.Drawing.Size(152, 22);
            this.TSItemOffline.Text = "离线";
            this.TSItemOffline.Image = ShowTypeResources.imoffline;
            this.TSItemOffline.Click += TSItem_Click;

            this.Items.AddRange(new ToolStripItem[] { 
                 this.TSItemNone,
            this.TSItemBusy,
            this.TSItemDnd,
            this.TSItemAway,
            this.TSItemInvisible,
            this.toolStripSeparator1,
            this.TSItemOffline});

            if (IsHideOfflineItem)
                HideOfflineItem();
        }

        void TSItem_Click(object sender, EventArgs e)
        {
            var item = sender as ToolStripMenuItem;
            if (item != null)
            {
                CommandLink.HeaderText = item.Text;
                CommandLink.Tag = item.Tag;
                CommandLink.ShowType = (ShowType)item.Tag;
                CommandLink.Image = (Bitmap)item.Image;
            }
        }

        public void HideOfflineItem()
        {
            this.toolStripSeparator1.Visible = false;
            this.TSItemOffline.Visible = false;
        }

    }
}
