﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.IO;
using System.Windows.Forms;
using Ourmsg.Enum; 
using IMLibrary.Security;
using  P ;

namespace OurMsg.Controls
{
    public partial class PanelLogin : UserControl
    {
        #region 构造函数
        public PanelLogin()
        {
            InitializeComponent();
            ButStatus.HideOfflineItem();
        }
        #endregion

        #region 事件
        public delegate void EventHandler(object sender, System.EventArgs  e);
        /// <summary>
        /// 登录事件
        /// </summary>
        public event EventHandler Login;
        private void onLogin()
        {
            if (Login != null)
                Login(this, null);

        }
        /// <summary>
        /// 取消登录事件
        /// </summary>
        public event EventHandler Cancel;
        private void onCancel()
        {
            if (Cancel != null)
                Cancel(this, null);

        }
        /// <summary>
        /// 注册新用户事件
        /// </summary>
        public event EventHandler Register;
        private void onRegister()
        {
            if (Register != null)
                Register(this, null);
        }
        #endregion

        #region 字段属性
        LoginInfo _loginInfo = new LoginInfo();
        /// <summary>
        /// 登录信息
        /// </summary>
        public LoginInfo loginInfo
        {
            set { _loginInfo = value; }
            get { return _loginInfo; }
        }
        #endregion

        #region checkBox事件
        private void checkBoxAutoLogin_CheckedChanged(object sender, EventArgs e)
        {
            if (checkBoxAutoLogin.Checked)
                checkBoxSavePwd.Checked = checkBoxAutoLogin.Checked;
        }

        private void checkBoxSavePwd_CheckedChanged(object sender, EventArgs e)
        {
            if (!checkBoxSavePwd.Checked)
                checkBoxAutoLogin.Checked = false;
        }
        #endregion

        #region 登录按键事件
        private void butLogin_Click(object sender, EventArgs e)
        {
            if (textBoxUserID.Text.Trim() == string.Empty || textBoxPassword.Text.Length  == 0)
            {
                Global.ShowMessage("请输入用户名和密码!");
                return;
            }

            loginInfo.UserID = textBoxUserID.Text.Trim();
            loginInfo.Password = Encryption.Encrypt3DES(textBoxPassword.Text);
            loginInfo.IsSavePassword = checkBoxSavePwd.Checked;
            loginInfo.IsAutoLogin = checkBoxAutoLogin.Checked;
            loginInfo.ShowType = (ShowType)ButStatus.Tag;

            this.panel1.Dock = DockStyle.Fill;
            this.panel1.Visible = true;
            this.loadingCircle1.Active = true;

            onLogin();
        }
        #endregion

        #region 取消按键
        private void butCancel_Click(object sender, EventArgs e)
        {
            HideCanlePanel();
            onCancel();
        }
        #endregion

        #region 隐藏取消登录面板
        /// <summary>
        /// 隐藏取消登录面板
        /// </summary>
        public void HideCanlePanel()
        {
            this.panel1.Visible = false;
            this.loadingCircle1.Active = false;
        }
        #endregion

        #region 加载登录用户信息
        /// <summary>
        /// 加载登录用户信息
        /// </summary>
        public  void LoadLoginUsers()
        {
            Random r = new Random();
            cMenu.AutoSize = false;

           var loginInfos=  OurMsg.OpeRecordDB.GetLoginInfos();
           if (loginInfos!=null)
            foreach (var loginInfo in loginInfos)
            {
                ToolStripMenuItem item = new ToolStripMenuItem();
                item.AutoSize = false;
                item.Size = new System.Drawing.Size(148, 36);
                item.ImageScaling = ToolStripItemImageScaling.SizeToFit;
                item.ImageTransparentColor = (Color.FromArgb(0, 128, 128));
                item.Text = loginInfo.UserID; 
                item.Tag = loginInfo;
                item.Image = Global.GetHeadImage(loginInfo.HeadID , ImageSize.P32X32);
                //Global.DrawImage(item.Image);
                if (loginInfo.IsSavePassword)
                    loginInfo.Password = Encryption.Decrypt3DES(loginInfo.Password);

                item.Click += new System.EventHandler(item_Click);

                item.MouseEnter += new System.EventHandler(item_MouseEnter);
                item.MouseLeave += new System.EventHandler(item_MouseLeave);
                item.MouseMove += new MouseEventHandler(item_MouseMove);
                item.MouseDown += new MouseEventHandler(item_MouseDown);
               
                cMenu.Height += item.Height; 
                cMenu.Items.Add(item);
            }
            cMenu.Width = 148;
            var renderer = new IMLibrary.Controls.Win8form.SharpMenuRenderer();
            renderer.IsDrawLine = false;
            cMenu.Renderer = renderer;
        }
        #endregion

        #region ToolStripMenuItem事件
        void item_MouseDown(object sender, MouseEventArgs e)
        {
             var item = sender as ToolStripMenuItem;
            if (item == null) return;
            int x = e.X, y = e.Y;
            var rect = new Rectangle(item.Width - 11 - 10 , (item.Height -16)/2, 11, 16);

            if ((x > rect.X && x <rect.X + rect.Width) && (y>rect.Y && y< rect.Y +rect.Height) )
            {
                Graphics g = cMenu.CreateGraphics();
                Bitmap image = new Bitmap(OurMsg.Properties.Resources.c3);
                Point p5 = new Point(rect.X,item.Bounds.Location.Y + rect.Y);
                g.DrawImage(image, p5);
                g.Dispose();

                if (MessageBox.Show("确定要删除此帐号登录信息吗？", "提示", MessageBoxButtons.YesNoCancel,
                    MessageBoxIcon.Question, MessageBoxDefaultButton.Button3) == DialogResult.Yes)
                {
                    var loginInfo = item.Tag as LoginInfo;
                    if (loginInfo != null)
                    {
                        OurMsg.OpeRecordDB.DeleteAuth(loginInfo.UserID);
                        cMenu.Items.Remove(item);
                        cMenu.Height -= item.Height;
                    }
                }
            }
            
        }

        bool IsToopTipShow = false;
        void item_MouseMove(object sender, MouseEventArgs e)
        {
            var item = sender as ToolStripMenuItem;
            if (item == null) return;
            int x = e.X, y = e.Y;
            var rect = new Rectangle(item.Width - 11 - 10, (item.Height - 16) / 2, 11, 16);

            if ((x > rect.X && x < rect.X + rect.Width) && (y > rect.Y && y < rect.Y + rect.Height))
            {
                Graphics g = cMenu.CreateGraphics();
                Bitmap image = new Bitmap(OurMsg.Properties.Resources.c2);
                Point p5 = new Point(rect.X, item.Bounds.Location.Y + rect.Y);
                g.DrawImage(image, p5);
                g.Dispose();

                if (!IsToopTipShow)
                {
                    toolTip1.Show("删除", item.Owner, item.Owner.Bounds.Width, item.Bounds.Location.Y + rect.Height);
                    IsToopTipShow = true;
                }
            }
            else
            {
                Graphics g = cMenu.CreateGraphics();
                Point p5 = new Point(rect.X, item.Bounds.Location.Y + rect.Y);
                Bitmap image = new Bitmap(20, 20);
                g.DrawImage(image, p5);
                image = new Bitmap(OurMsg.Properties.Resources.c1);
                g.DrawImage(image, p5);
                g.Dispose();

                toolTip1.Hide(item.Owner);
                IsToopTipShow = false;
            }
        }

        void item_MouseLeave(object sender, EventArgs e)
        {
            var item = sender as ToolStripMenuItem;
            if (item == null) return;
            var loginInfo = item.Tag as LoginInfo;
            if (loginInfo != null)
                item.Text = loginInfo.UserID;

            toolTip1.Hide(item.Owner);
            IsToopTipShow = false;
        }

        void item_MouseEnter(object sender, EventArgs e)
        {
            var item = sender as ToolStripMenuItem;
            if (item == null) return;
            var loginInfo = item.Tag as LoginInfo;
            if (loginInfo != null)
                item.Text = loginInfo.UserID + "\r\n" + loginInfo.UserName ;
             
        }

        void item_Click(object sender, EventArgs e)
        {
            var item = sender as ToolStripMenuItem;
            if (item == null) return;
            pictureBox1.Image = item.Image;
              var loginInfo = item.Tag as LoginInfo;
              if (loginInfo != null)
              {
                  textBoxUserID.Text = loginInfo.UserID;
                  textBoxPassword.Text = (loginInfo.Password == null ? "" : loginInfo.Password);
                  checkBoxAutoLogin.Checked = loginInfo.IsAutoLogin;
                  checkBoxSavePwd.Checked = loginInfo.IsSavePassword;
                  ButStatus.SetShowType(loginInfo.ShowType);
              }
        }
        #endregion

        #region 头像下拉按键
        private void commandLink1_Click(object sender, EventArgs e)
        {
            cMenu.Show(textBoxUserID, new Point(0, textBoxUserID.Height));
        }
        #endregion

        #region 注册新用户事件
        private void linkLabelRegister_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            onRegister();
        }
        #endregion

        #region 设置新注册用户帐号
        /// <summary>
        /// 设置新注册用户帐号
        /// </summary>
        /// <param name="userID"></param>
        public void setNewUserID(UInt32 userID)
        {
            if (userID != 0)
            {
                this.textBoxUserID.Text = userID.ToString();
                this.textBoxPassword.Text = string.Empty;
            }
        }
        #endregion

    }
}
