﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using IMLibrary.Net.Enum;
using Ourmsg.Enum;
using IMLibrary.AV;
using P;

namespace OurMsg.Controls
{
    public partial class RemoteHelpControlV1 : UserControl
    {
        /// <summary>
        /// 
        /// </summary>
        /// <param name="serverIP"></param>
        /// <param name="port"></param>
        /// <param name="isContorler"></param>
        public RemoteHelpControlV1(string serverIP, int port, bool isContorler = false)
        {
            InitializeComponent();
            IsControler = isContorler;
            ServerIP = serverIP;
            Port = port;
        }

        #region 属性
        private bool isControler = false;
        /// <summary>
        /// 是否控制端(控制端不用发送桌面图像给对方)
        /// </summary>
        bool IsControler
        {
            set
            {
                isControler = value;
                linkLabelRec.Visible = value;
                checkBox1.Visible = !value;
                if (value)
                    this.label1.Text = "对方邀请您远程协助...";
                else
                    this.label1.Text = "请求对方远程协助...";
            }
            get { return isControler; }
        }
        /// <summary>
        /// 对方屏幕宽度
        /// </summary>
        private int ToScreenWidth { set; get; }
        /// <summary>
        /// 对方屏幕高度
        /// </summary>
        private int ToScreenHeight { set; get; }
        /// <summary>
        /// 对方桌面窗口标题
        /// </summary>
        private string DesktopTilte = "对方桌面";
        /// <summary>
        /// 
        /// </summary>
        RemoteHelpV1 remoteHelp = null;
        /// <summary>
        /// 
        /// </summary>
        frmDesktop fDesktop = null;
        /// <summary>
        /// 
        /// </summary>
        bool AllowControl { set; get; }
        /// <summary>
        /// 
        /// </summary>
        string ServerIP = "127.0.0.1";
        /// <summary>
        /// 
        /// </summary>
        int Port = 0;
        /// <summary>
        /// 
        /// </summary>
        bool isIni = false;

        #endregion

        #region 事件
        /// <summary>
        /// 获得IPEndPoint事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="local">本地主机信息</param>
        /// <param name="remote">远程主机信息</param>
        public delegate void EventHandler(object sender, RemoteHelp e);
        public event EventHandler ServerRegistered;
        private void OnServerRegistered(long hostID)
        {
            if (ServerRegistered != null)
            {
                Rectangle screenArea = Rectangle.Empty;
                screenArea = Rectangle.Union(screenArea, Screen.PrimaryScreen.Bounds);
                RemoteHelp rh = new RemoteHelp(OprationType.Set);
                rh.RemoteHostID = hostID;
                rh.ScreenHeight = screenArea.Height;
                rh.ScreenWidth = screenArea.Width;
                ServerRegistered(this, rh);//触发获取本机主机事件
            }
        }

        /// <summary>
        /// 取消事件
        /// </summary>
        public event EventHandler Cancel;
        private void OnCancel()
        {
            if (Cancel != null)
            {
                RemoteHelp rh = new RemoteHelp(OprationType.Cancel);
                Cancel(this, rh);
            }
        }
        #endregion

        #region 初始化本地组件

        private void IniLocalControls()
        {
            if (isIni) return;
            isIni = true;

            if (remoteHelp == null)
            {
                remoteHelp = new RemoteHelpV1(ServerIP, Port, !isControler);
                remoteHelp.ServerRegistered += (s, e) =>
                    {
                        OnServerRegistered(e.ServerID);
                    };
                remoteHelp.Connected += (s, e) =>
                    {
                        if (remoteHelp.ConnectionType == ConnectionType.UDPDirect)
                            this.label1.Text = "已建立UDP直接！";
                        else if (remoteHelp.ConnectionType == ConnectionType.UDPTurn)
                            this.label1.Text = "已建立UDP中转连接！";

                        remoteHelp.AllowControl = AllowControl;
                    };
                remoteHelp.ReceiveFirstImage += (s, e) =>
                    {
                        //delegateShowRemoteDesktopForm d = new delegateShowRemoteDesktopForm(ShowRemoteDesktopForm);
                        //    this.Invoke(d);
                        ShowRemoteDesktopForm();
                    };
                remoteHelp.Start();
            }
        }
        #endregion

        private void linkLabelCancel_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            if (fDesktop != null && !fDesktop.IsDisposed)//如果是控制者
            {
                fDesktop.IsSelfClose = false;
                fDesktop.Close();
                fDesktop.Dispose();
                fDesktop = null;
            }
            OnCancel();
        }

        private void linkLabelRec_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            linkLabelRec.Visible = false;
            IniLocalControls();
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            if (remoteHelp != null)
                remoteHelp.AllowControl = checkBox1.Checked;
            AllowControl = checkBox1.Checked;
        }


        #region 显示远程桌面
        delegate void delegateShowRemoteDesktopForm();
        private void ShowRemoteDesktopForm()
        {
            if (isControler && fDesktop == null)//如果是控制者
            {
                fDesktop = new frmDesktop(new Size(ToScreenWidth, ToScreenHeight), DesktopTilte);

                fDesktop.FormClosed += (s1, e1) =>
                {
                    if (fDesktop.IsSelfClose)
                        linkLabelCancel_LinkClicked(null, null);
                };
                fDesktop.KeyDown += (sender, e) =>
                {
                    remoteHelp.sendKeyDown(e.KeyCode);
                };
                fDesktop.KeyUp += (sender, e) =>
                {
                    remoteHelp.sendKeyUp(e.KeyCode);
                };
                remoteHelp.picBox = fDesktop.pictureBox1;
                fDesktop.Show();
            }
        }
        #endregion


        /// <summary>
        /// 设置远程主机信息
        /// </summary>
        /// <param name="desktopTilte"></param>
        /// <param name="hostID"></param>
        /// <param name="remoteDesktopWidth"></param>
        /// <param name="remoteDesktopHeight"></param>
        public void setRemoteHostIDandScreen(string desktopTilte, long hostID, int remoteDesktopWidth = 0, int remoteDesktopHeight = 0)
        {
            ToScreenWidth = remoteDesktopWidth;
            ToScreenHeight = remoteDesktopHeight;
            this.DesktopTilte = desktopTilte;
            IniLocalControls();
            remoteHelp.setRemoteHostIDandScreen(hostID, remoteDesktopWidth, remoteDesktopHeight);
        }


        public void CancelRemoteHelp()
        {
            if (remoteHelp != null)
            {
                if (fDesktop != null && !fDesktop.IsDisposed)//如果是控制者
                {
                    fDesktop.IsSelfClose = false;
                    fDesktop.Close();
                    fDesktop.Dispose();
                    fDesktop = null;
                }
                remoteHelp.CancelTransmit();
            }
            this.Dispose();
        }
    }
}
