﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace OurMsg
{
    public partial class FormAddGroup : IMLibrary.Controls.ExControls.FormEx 
    {
        public FormAddGroup( )
        {
            InitializeComponent();
            gOper.cmd = P.GroupInfoOperationCmd.Add;
        }

        P.GroupInfoOperation gOper = new P.GroupInfoOperation();

        #region 事件
        /// <summary>
        /// 发送事件代理
        /// </summary>
        /// <param name="Msg">要发送的消息</param>
        public delegate void EventHandler(object sender, object Msg);
        /// <summary>
        /// 创建消息事件
        /// </summary>
        public event EventHandler CreateMsgAfter;
        /// <summary>
        /// 
        /// </summary>
        /// <param name="msg"></param>
        private void OnCreateMsgAfter( object msg)
        { 
            if (CreateMsgAfter != null)
                CreateMsgAfter(this, msg);
        }
        #endregion

        private void FormAddGroup_Load(object sender, EventArgs e)
        {

        }

        private string _groupName;
        public string GroupName
        {
            set { _groupName = value; }
            get { return _groupName; }
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            var groupName = textBoxGroupName.Text.Trim();
            if (groupName == string.Empty)
            {
                Global.ShowMessage("组名必须填写！");
                textBoxGroupName.Focus();
                return;
            }
            foreach (var g in Global.Groups.Values)
                if (groupName == g.GroupName)
                {
                    Global.ShowMessage("组名不能与其他分组名称相同！");
                    textBoxGroupName.Focus();
                    return;
                }

            this.UseWaitCursor = true;

            gOper.GroupName = groupName;
            OnCreateMsgAfter(gOper);
            timer1.Enabled = true;
        }

        int count = 0;
        private void timer1_Tick(object sender, EventArgs e)
        {
            if (this.GroupName != null)
            {
                timer1.Enabled = false;
                this.Close();
                this.Dispose();
            }
            if (count == 30)
            {
                timer1.Enabled = false;
                this.Close();
                this.Dispose();
            }
            count++;
        }
    }
}
