﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using P;

namespace OurMsg
{
    public partial class FormInviteMsg : IMLibrary.Controls.ExControls.FormEx
    {
        public FormInviteMsg()
        {
            InitializeComponent();
        }

        private void FormInviteMsg_Load(object sender, EventArgs e)
        {
            for (int i = 0; i < 2; i++)
            {
                AddInviteUserMsg(null);
            }

            for (int i = 0; i < 2; i++)
            {
                AddInviteRoomMsg(null);
            }
        }

        #region 事件
        /// <summary>
        /// 发送事件代理
        /// </summary>
        /// <param name="Msg">要发送的消息</param>
        public delegate void CreateMsgEventHandler(object sender, Element Msg);
        /// <summary>
        /// 
        /// </summary>
        public event CreateMsgEventHandler CreateMsgAfter;
        /// <summary>
        /// 
        /// </summary>
        /// <param name="msg"></param>
        private void OnCreateMsgAfter(Element msg)
        {
            if (CreateMsgAfter != null)
                CreateMsgAfter(this, msg);
        }
        #endregion

        /// <summary>
        /// 添加邀请加为好友消息
        /// </summary>
        /// <param name="msg"></param>
        public void AddInviteUserMsg(InviteMsg msg)
        {
            OurMsg.Controls.InviteMsgControl imc = new Controls.InviteMsgControl(OurMsg.Controls.InviteMsgControl.InviteMsgType.User, msg);
            flowLayoutPanelUser.Controls.Add(imc);
            imc.Width = flowLayoutPanelUser.Width - 25;
        }

        /// <summary>
        /// 添加邀请入群消息
        /// </summary>
        /// <param name="msg"></param>
        public void AddInviteRoomMsg(InviteMsg msg)
        {
            OurMsg.Controls.InviteMsgControl imc = new Controls.InviteMsgControl(OurMsg.Controls.InviteMsgControl.InviteMsgType.Room, msg);
            flowLayoutPanelRoom.Controls.Add(imc);
            imc.Width = flowLayoutPanelUser.Width - 25;
        }
    }
}
