﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace OurMsg
{
    public partial class FormRespondAddFriendorRoom : IMLibrary.Controls.ExControls.FormEx 
    {
        /// <summary>
        /// 添加群或好友类型
        /// </summary>
        public enum AddType
        {
            None = 0,
            /// <summary>
            /// 添加好友请求
            /// </summary>
            RequestAddFriend = 1,
            /// <summary>
            /// 添加群请求
            /// </summary>
            RequestAddRoom = 2,
            /// <summary>
            /// 邀请添加群
            /// </summary>
            InviteAddRoom = 3,
            /// <summary>
            /// 拒绝添加好友
            /// </summary>
            refuseAddFriend,
            /// <summary>
            /// 拒绝添加群
            /// </summary>
            refuseAddRoom,
            /// <summary>
            /// 拒绝加入群
            /// </summary>
            refuseInviteAddRoom
        }

        public FormRespondAddFriendorRoom(AddType type, P.InviteMsg msg)
        {
            InitializeComponent();

            this.addType = type;
            this.Msg = msg;

            pictureBoxHead.Image = Global.GetHeadImage(msg.HeadID, ImageSize.P32X32);
            linkLabelRequestUser.Text = string.Format("{0}({1})", msg.UserName, msg.UserID);
            if (msg.AttachMsg == null)
                msg.AttachMsg = string.Empty;
            labelAttachMsg.Text = msg.AttachMsg;

            if (type == AddType.RequestAddFriend)
            {
                this.Text = "请求添加好友";
                labelInvite.Text = "请求添加您为好友.";
                linkLabelRoom.Visible = false;
            }
            else if (type == AddType.RequestAddRoom)
            {
                this.Text = "请求添加群";
                labelInvite.Text = "请求添加群：";
                linkLabelRoom.Visible = true;
                linkLabelRoom.Text = string.Format("{0}({1})", msg.RoomName, msg.RoomID);
            }
            else if (type == AddType.InviteAddRoom )
            {
                this.Text = "邀请加入群"; 
                labelInvite.Text = "邀请您加入群:";
                linkLabelRoom.Visible = true;
                linkLabelRoom.Text = string.Format("{0}({1})", msg.RoomName, msg.RoomID);
            }
        }

        /// <summary>
        /// 添加类型
        /// </summary>
        AddType addType = AddType.None;
        /// <summary>
        /// 请求参数
        /// </summary>
        P.InviteMsg Msg = new P.InviteMsg();

        private void linkLabelAgree_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Response(true);//同意添加 
        }

        private void linkLabelRefuse_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Response(false);//拒绝添加
        }

        /// <summary>
        /// 回应添加请求
        /// </summary>
        /// <param name="Agree"></param>
        private void Response(bool Agree)
        {
            if (this.addType == AddType.RequestAddFriend)
                Global.MsgClient.ResponsesAddFriend(Agree, Msg.UserID, "","",-1);
            else if (this.addType == AddType.RequestAddRoom)
                Global.MsgClient.ResponsesAddRoom(Agree, Msg.RoomID, Msg.UserID, "");
            else if (this.addType == AddType.InviteAddRoom)
                Global.MsgClient.ResponsesInviteAddRoom(Agree, Msg.RoomID, Msg.UserID, "", "", -1);

            this.Close();
            this.Dispose();
        }
    }
}
