﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.IO;
using P;
using OurMsg.Class;
using IMLibrary.Controls.Toolbox;

namespace OurMsg
{
    public class Global
    { 
        #region 服务器相关配置（登录时来自于登录服务器）
        /// <summary>
        /// 服务器IP 
        /// </summary>
        public const string ServerIP ="127.0.0.1";//  
        /// <summary>
        /// P2P服务器IP
        /// </summary>
        public static string P2PServerIP = ServerIP;
        /// <summary>
        /// 离线文件服务器IP
        /// </summary>
        public static string OfflineFileServerIP = ServerIP;
        /// <summary>
        /// P2P服务端口
        /// </summary>
        public static int P2PServerPort = 14343;
        /// <summary>
        /// 离线文件服务端口
        /// </summary>
        public static int OfflineFileServerPort = 88;
        /// <summary>
        /// 图片文件TCP服务端口
        /// </summary>
        public static int ImageServerTcpPort = 90;
        /// <summary>
        /// 图片文件UDP服务端口
        /// </summary>
        public static int ImageServerUdpPort = 90;

        /// <summary>
        /// 登录信息
        /// </summary>
        public static LoginInfo loginInfo = new LoginInfo();
        #endregion

        #region 集合操作
        /// <summary>
        /// ourmsg 消息客户端
        /// </summary>
        public static Ourmsg.APPClient.MsgClient MsgClient;
        /// <summary>
        /// 用户集合
        /// </summary>
        public static Dictionary<UInt32, ExUser> Users = new Dictionary<uint, ExUser>();
        /// <summary>
        /// 群集合
        /// </summary>
        public static Dictionary<UInt32, ExRoom> Rooms = new Dictionary<uint, ExRoom>();
        /// <summary>
        /// 分组集合
        /// </summary>
        public static Dictionary<Int32, ExGroup> Groups = new Dictionary<Int32, ExGroup>();
        /// <summary>
        /// 群分组集合
        /// </summary>
        public static Dictionary<Int32, ExGroup> RoomGroups = new Dictionary<Int32, ExGroup>();
        /// <summary>
        /// 群设置窗口集合
        /// </summary>
        static List<FormSetRoom> formSetRooms = new List<FormSetRoom>();
        /// <summary>
        /// 添加好友窗口
        /// </summary>
        public static List<FormAddFriendorRoom> AddFriendFrms = new List<FormAddFriendorRoom>();
        /// <summary>
        /// 添加群窗口
        /// </summary>
        public static List<FormAddFriendorRoom> AddRoomFrms = new List<FormAddFriendorRoom>();
        /// <summary>
        /// 陌生人聊天窗口集合
        /// </summary>
        public static List<FormTalkUser> StrangerForms = new List<FormTalkUser>();

        /// <summary>
        /// 添加用户分组窗口
        /// </summary>
        public static FormAddGroup AddUserGroupForm;
        /// <summary>
        /// 添加群分组窗口
        /// </summary>
        public static FormAddGroup AddRoomGroupForm;


        public static Toolbox.Tab TabDevice;// = new Toolbox.Tab("我的设备");
        public static Toolbox.Tab TabFriend;//= new Toolbox.Tab("我的好友");
        public static Toolbox.Tab TabStranger;// = new Toolbox.Tab("陌生人");
        public static Toolbox.Tab TabBlacklist;// = new Toolbox.Tab("黑名单");
        public static Toolbox.Tab TabMyRoom;// = new Toolbox.Tab("我的群");
        #endregion

        #region 初始化基本组
        /// <summary>
        /// 初始化基本组
        /// </summary>
        public static void IniBaseGroup(IMLibrary.Controls.Toolbox.Toolbox toolboxUsers, IMLibrary.Controls.Toolbox.Toolbox toolboxRooms)
        {
            TabDevice = toolboxUsers.AddGroup("我的设备");
            TabDevice.AllowDelete = false;
            TabDevice.AllowDrag = false;
            TabDevice.AllowDropItem = false;
            TabDevice.FlickerIcons();
            TabFriend = toolboxUsers.AddGroup("我的好友");
            TabFriend.AllowDelete = false;
            TabFriend.AllowDrag = false;
            TabFriend.AllowDropItem = false;
            TabFriend.FlickerIcons();
            TabStranger = toolboxUsers.AddGroup("陌生人");
            TabStranger.AllowDelete = false;
            TabStranger.AllowDrag = false;
            TabStranger.AllowDropItem = false;
            TabStranger.FlickerIcons();
            TabBlacklist = toolboxUsers.AddGroup("黑名单");
            TabBlacklist.AllowDelete = false;
            TabBlacklist.AllowDrag = false;
            TabBlacklist.AllowDropItem = false;
            TabBlacklist.FlickerIcons();

            TabMyRoom = toolboxRooms.AddGroup("我的群");
            TabMyRoom.AllowDelete = false;
            TabMyRoom.AllowDrag = false;
            TabMyRoom.AllowDropItem = false;
            TabMyRoom.FlickerIcons();
        }
        #endregion

        #region 字典操作

        #region 获得群设置窗口
        public static FormSetRoom GetFormSetRoom(UInt32 roomID)
        {
            var room = GetRoom(roomID);
            if (room == null) return null;

            foreach (FormSetRoom frm in formSetRooms)
                if (frm.Tag.ToString() == roomID.ToString())
                    return frm;

            return null;
        }


        /// <summary>
        /// 获得群设置窗口
        /// </summary>
        /// <returns></returns>
        public static void ShowFormSetRoom(UInt32 roomID)
        {
            var room = GetRoom(roomID);
            if (room == null) return;
            bool t = false;

            foreach (FormSetRoom frm in formSetRooms)
                if (frm.Tag.ToString() == roomID.ToString())
                {
                    frm.Show(); frm.Activate();
                    t = true;
                }

            if (!t)
            {
                FormSetRoom frm = new FormSetRoom();
                frm.Tag = roomID;
                frm.FormClosed += (s, e) => DelFormSetRoom(room.BaseInfo.RoomID);
                frm.CreateMsgAfter += (s, e) =>//消息创建事件
                {
                    if (e is RoomBaseInfo)//如果变更群基本信息
                    {
                        var r = e as RoomBaseInfo;
                        MsgClient.UpdateRoomBaseInfo(roomID,r.RoomName,r.AddCondition,r.Notice,r.Remark );
                    }
                    else if (frm.cmdType == Ourmsg.Enum.CommandType.DelRoomUser)//如果删除群用户
                    {
                        MsgClient.DelRoomUser(roomID, (e as RoomUser).UserID);
                    } 
                    else if (frm.cmdType == Ourmsg.Enum.CommandType.SetRoomManger)//如果设置管理员
                    {
                        MsgClient.SetRoomManger(roomID, (e as RoomUser).UserID, (e as RoomUser).Admin);
                    }
                    else if (frm.cmdType == Ourmsg.Enum.CommandType.SetRoomUserCard)//如果设置管理员
                    {
                        MsgClient.SetRoomUserCard(roomID, (e as RoomUser).UserID, (e as RoomUser).UserCard);
                    }
                };
                formSetRooms.Add(frm);
                frm.SetRoomData(room);
                frm.Show(); frm.Activate();
            } 
        }

        static void DelFormSetRoom(UInt32 roomID)
        {
            foreach (FormSetRoom frm in formSetRooms.ToArray())
                if (frm.Tag.ToString() == roomID.ToString())
                    formSetRooms.Remove(frm);
        }
        #endregion

        #region 获得群中用户
        /// <summary>
        /// 获得群中用户
        /// </summary>
        /// <param name="roomID"></param>
        /// <param name="userID"></param>
        /// <returns></returns>
        public static RoomUser GetRoomUser(UInt32 roomID, UInt32 userID)
        {
            ExRoom r = GetRoom(roomID);
            if (r == null) return null;

            return r.GetUser(userID);
        }
        #endregion

        #region 判断用户是否群主
        /// <summary>
        /// 判断用户是否群主
        /// </summary>
        /// <param name="roomID"></param>
        /// <param name="userID"></param>
        /// <returns></returns>
        public static bool IsRoomCreater(UInt32 roomID, UInt32 userID)
        {
            var r = GetRoom(roomID);
            if (r == null) return false;

            if (r.BaseInfo.CreateUserID == userID)
                return true;

            return false;
        }
        #endregion

        #region 获得在线用户
        /// <summary>
        /// 获得在线用户
        /// </summary>
        /// <param name="userID"></param>
        /// <returns></returns>
        public static ExUser GetUser(UInt32 userID)
        {
            ExUser u = null;
            Users.TryGetValue(userID, out u);
            return u;
        }
        #endregion

        #region 删除用户
        /// <summary>
        /// 删除用户
        /// </summary>
        /// <param name="userID"></param>
        /// <returns></returns>
        public static bool DelUser(UInt32 userID)
        {
            bool t = false;
            lock (Users)
                t = Users.Remove(userID);
            return t;
        }
        #endregion

        #region 获得分组
        /// <summary>
        /// 获得分组
        /// </summary>
        /// <param name="userID"></param>
        /// <returns></returns>
        public static ExGroup GetGroup(Int32 groupID)
        {
            ExGroup g = null;
            Groups.TryGetValue(groupID, out g);
            return g;
        }
        #endregion

        #region 获得分组
        /// <summary>
        /// 获得分组
        /// </summary>
        /// <param name="groupName"></param>
        /// <returns></returns>
        public static ExGroup GetGroup(string  groupName)
        { 
            foreach (var g in Groups.Values)
                if (g.GroupName == groupName)
                    return g;
            return null ;
        }
        #endregion

        #region 删除分组
        /// <summary>
        /// 删除分组
        /// </summary>
        /// <param name="userID"></param>
        /// <returns></returns>
        public static bool DelGroup(Int32 groupID)
        {
            bool t = false;
            lock (Groups)
                t = Groups.Remove(groupID);
            return t;
        }
        #endregion

        #region 获得群分组
        /// <summary>
        /// 获得群分组
        /// </summary>
        /// <param name="userID"></param>
        /// <returns></returns>
        public static ExGroup GetRoomGroup(Int32 groupID)
        {
            ExGroup g = null;
            RoomGroups.TryGetValue(groupID, out g);
            return g;
        }
        #endregion

        #region 获得群分组
        /// <summary>
        /// 获得群分组
        /// </summary>
        /// <param name="groupName"></param>
        /// <returns></returns>
        public static ExGroup GetRoomGroup(string groupName)
        {
            foreach (var g in RoomGroups.Values)
                if (g.GroupName == groupName)
                    return g;
            return null;
        }
        #endregion

        #region 删除分组
        /// <summary>
        /// 删除分组
        /// </summary>
        /// <param name="userID"></param>
        /// <returns></returns>
        public static bool DelRoomGroup(Int32 groupID)
        {
            bool t = false;
            lock (RoomGroups)
                t = RoomGroups.Remove(groupID);
            return t;
        }
        #endregion

        #region 获得群
        /// <summary>
        /// 获得群
        /// </summary>
        /// <param name="userID"></param>
        /// <returns></returns>
        public static ExRoom GetRoom(UInt32 roomID)
        {
            ExRoom r = null;
            Rooms.TryGetValue(roomID, out r);
            return r;
        }
        #endregion

        #region 删除群
        /// <summary>
        /// 删除群
        /// </summary>
        /// <param name="userID"></param>
        /// <returns></returns>
        public static bool DelRoom(UInt32 RoomID)
        {
            bool t = false;
            lock (Rooms)
                t = Rooms.Remove(RoomID);
            return t;
        }
        #endregion

        #endregion

        #region 显示添加用户分组对话框
        /// <summary>
        /// 显示添加用户分组对话框
        /// </summary>
        public static void ShowAddUserGroupForm(FormAddFriendorRoom frm)
        {
            if (AddUserGroupForm == null || AddUserGroupForm.IsDisposed)
            {
                AddUserGroupForm = new FormAddGroup();
                AddUserGroupForm.CreateMsgAfter += (s, e) =>
                    {
                        GroupInfoOperation gOper = e as GroupInfoOperation;
                        if (gOper == null) return;
                        MsgClient.AddUserGroupInfo(gOper.GroupName);
                    };
                AddUserGroupForm.FormClosing += (s, e) =>
                    {
                        if (AddUserGroupForm.GroupName != null)
                            frm.AddGroup(0, AddUserGroupForm.GroupName);
                    };
            }
            AddUserGroupForm.ShowDialog(frm); 
        }

        
        #endregion

        #region 显示添加用户群分组对话框
        /// <summary>
        /// 显示添加用户群分组对话框
        /// </summary>
        public static void ShowAddRoomGroupForm(FormAddFriendorRoom frm)
        {
            if (AddRoomGroupForm == null || AddRoomGroupForm.IsDisposed)
            {
                AddRoomGroupForm = new FormAddGroup();
                AddRoomGroupForm.CreateMsgAfter += (s, e) =>
                {
                    GroupInfoOperation gOper = e as GroupInfoOperation;
                    if (gOper == null) return;
                    MsgClient.AddRoomGroupInfo (gOper.GroupName);
                };
                AddRoomGroupForm.FormClosing += (s, e) =>
                {
                    if (AddRoomGroupForm.GroupName != null)
                        frm.AddGroup(0, AddRoomGroupForm.GroupName);
                };
            }
            AddRoomGroupForm.Show();
            AddRoomGroupForm.Activate();
        }
        #endregion

        #region 获得添加好友验证窗口
        /// <summary>
        /// 获得添加好友验证窗口
        /// </summary>
        /// <param name="userID"></param>
        /// <returns></returns>
        public static FormAddFriendorRoom GetAddFriendFrm(UInt32 userID)
        {
            foreach (var f in AddFriendFrms)
                if (f.ID == userID)
                    return f;
            return null;
        }
        #endregion

        #region 获得添加好友验证窗口
        /// <summary>
        /// 获得添加好友验证窗口
        /// </summary>
        /// <param name="userID"></param>
        /// <returns></returns>
        public static FormAddFriendorRoom GetAddRoomFrm(UInt32 roomID)
        {
            foreach (var f in AddRoomFrms)
                if (f.ID == roomID)
                    return f;
            return null;
        }
        #endregion

        #region 获取群聊天窗体
        /// <summary>
        /// 获取群聊天窗体
        /// </summary>
        /// <param name="roomID"></param>
        /// <returns></returns>
        public static FormTalkRoom GetRoomTalkForm(UInt32 roomID)
        {
            var r = GetRoom(roomID); if (r == null) return null;
            if (r.formTalk == null || r.formTalk.IsDisposed)
                return null;
            r.formTalk.Show();
            r.formTalk.Activate();
            return r.formTalk;
        }
        /// <summary>
        /// 获取群聊天窗体
        /// </summary>
        /// <param name="u"></param>
        /// <returns></returns>
        public static FormTalkRoom ShowTalkForm(ExRoom r)
        {
            if (r.formTalk == null || r.formTalk.IsDisposed)
            {
                r.formTalk = new FormTalkRoom();
                r.formTalk.SetRoomInfo(r.BaseInfo);
                r.formTalk.RoomID = r.BaseInfo.RoomID;
                r.formTalk.UserID = UInt32.Parse(loginInfo.UserID);
                r.formTalk.UserName = loginInfo.UserName;
                r.formTalk.Icon = Icon.FromHandle(((Bitmap)Global.GetHeadImage("Room", ImageSize.P24X24)).GetHicon());
                r.formTalk.CreateMsgAfter += (s, e) =>
                { 
                    MsgClient.SendMessageToRoom(e, r.BaseInfo.RoomID); 
                    if (e is P.Message)
                    {
                        var msg = e as P.Message;
                        msg.From = Convert.ToUInt32(loginInfo.UserID);
                        msg.FromName = loginInfo.UserName;
                        msg.FromHeadID = loginInfo.HeadID;
                        msg.DateTime = DateTime.Now.ToString();
                        OpeRecordDB.AddMsg(msg, MsgType.roomMsg, Convert.ToUInt32(loginInfo.UserID), r.BaseInfo.RoomID, true);
                    }
                };
                MsgClient.GetRoomData(r.BaseInfo.RoomID);//获取群成员基本资料
            }

            var item = r.ToolboxItem;
            if (item.HaveMessage)
            {
                Global.DelRecMsg(MsgType.roomMsg, r.BaseInfo.RoomID);
                var msgs = OpeRecordDB.GetMsgs(MsgType.roomMsg, r.BaseInfo.RoomID, false);
                OpeRecordDB.UpdateShowMsg(MsgType.roomMsg, r.BaseInfo.RoomID);
                if (msgs != null)
                    foreach (var msg in msgs)
                        r.formTalk.AddMsg(msg);
            }
            item.HaveMessage = false;
            r.formTalk.Show(); r.formTalk.Activate();
            return r.formTalk;
        }
        #endregion

        #region 获取好友聊天窗体
        /// <summary>
        /// 获取好友聊天窗体
        /// </summary>
        /// <param name="userID"></param>
        /// <returns></returns>
        public static FormTalkUser GetUserTalkForm(UInt32 userID)
        {
            var u = GetUser(userID); if (u == null) return null;
            if (u.formTalk == null || u.formTalk.IsDisposed)
                return null;

            u.formTalk.Show();
            u.formTalk.Activate();
            return u.formTalk;
        }


        /// <summary>
        /// 根据群用户信息获取并显示聊天窗口
        /// </summary>
        /// <param name="u"></param>
        /// <returns></returns>
        public static void  ShowTalkForm(RoomUser roomUser)
        {
            var user = GetUser(roomUser.UserID);
            if (user == null)
                user = AddStranger(roomUser.UserID,roomUser.UserName ,roomUser.HeadID); 
            ShowTalkForm(user);
        }

        /// <summary>
        /// 获取好友聊天窗体
        /// </summary>
        /// <param name="u"></param>
        /// <returns></returns>
        public static  FormTalkUser ShowTalkForm(ExUser u)
        {
            if (u.formTalk == null || u.formTalk.IsDisposed)
            {
                u.formTalk = new FormTalkUser();
                u.formTalk.CreateMsgAfter += (s, e) =>
                {
                    MsgClient.SendMessageToUser(e, u.UserID);
                    if (e is P.Message)
                    {
                        var msg = e as P.Message;
                        msg.From = Convert.ToUInt32(loginInfo.UserID);
                        msg.FromName = loginInfo.UserName;
                        msg.FromHeadID = loginInfo.HeadID;
                        msg.DateTime = DateTime.Now.ToString();
                        OpeRecordDB.AddMsg(msg, MsgType.userMsg, Convert.ToUInt32(loginInfo.UserID), u.UserID, true);
                    }
                };
            }
            var item = u.ToolboxItem;
            var username = u.RemarkName;
            if (string.IsNullOrEmpty(username))
                username = u.UserName;
            u.formTalk.Text = string.Format("与 {0}({1}) 对话", username, u.UserID);
            u.formTalk.UserID =UInt32 .Parse( loginInfo.UserID);
            u.formTalk.UserName = loginInfo.UserName;
            //u.formTalk.Icon = Global.GetHeadImage(u.HeadID.ToString(), ImageSize.P24X24);
            if (item.HaveMessage)
            {
                Global.DelRecMsg(MsgType.userMsg, u.UserID);
                var msgs = OpeRecordDB.GetMsgs(MsgType.userMsg, u.UserID, false);
                OpeRecordDB.UpdateShowMsg(MsgType.userMsg, u.UserID);
                if (msgs != null)
                    foreach (var msg in msgs)
                        u.formTalk.AddMsg(msg);
            }
            item.HaveMessage = false;
            u.formTalk.Show(); u.formTalk.Activate();
            return u.formTalk;
        }
        #endregion

        #region 添加陌生人
        /// <summary>
        /// 添加陌生人
        /// </summary>
        public static ExUser AddStranger(UInt32 userID, string userName, int headID)
        {
            ExUser user = new ExUser();
            user.UserID = userID;
            user.UserName = userName;
            var HeadID = headID.ToString();
            Image image = Global.GetHeadImage(HeadID, ImageSize.P32X32);
            Image smallImage = Global.GetHeadImage(HeadID, ImageSize.P20X20);
            var item = new IMLibrary.Controls.Toolbox.Toolbox.Item(user.UserName);
            item.Image = smallImage;
            item.NotSelectedImage = smallImage; item.SelectedImage = image;
            item.Tag = user;
            TabStranger.Items.Add(item);
            user.ToolboxItem = item;
            Global.Users.Add(user.UserID, user);
            return user;
        }
        #endregion

        #region 收到消息集合
        /// <summary>
        /// 收到的消息集合
        /// </summary>
        public static List<ReceiveMsg> RecMsgs = new List<ReceiveMsg>();
        /// <summary>
        /// 添加消息
        /// </summary>
        /// <param name="ID"></param>
        /// <param name="msgType"></param>
        /// <param name="image"></param>
        /// <param name="obj"></param>
        /// <returns></returns>
        public static ReceiveMsg AddRecMsgs(UInt32 ID, MsgType msgType, Image image, object obj)
        {
            ReceiveMsg msg = null;

            foreach (var m in RecMsgs.ToArray())
                if (m.ID == ID && m.msgType == msgType)
                    msg = m;


            if (msg != null)
                lock (RecMsgs)
                {
                    RecMsgs.Remove(msg);
                    RecMsgs.Insert(0, msg);
                }
            else
            {
                msg = new ReceiveMsg();
                lock (RecMsgs)
                    RecMsgs.Insert(0, msg);
            }

            msg.image = Icon.FromHandle(((Bitmap)image).GetHicon());
            msg.msgCount += 1;
            msg.msgType = msgType; 
            msg.ID = ID;
            msg.Tag = obj;
            return msg;
        }

        /// <summary>
        /// 删除消息
        /// </summary>
        /// <param name="ID">用户帐号或群帐号</param>
        public static void DelRecMsg(MsgType msgType, UInt32 ID)
        {
            foreach (var msg in RecMsgs.ToArray())
                if (msg.ID == ID && msg.msgType == msgType)
                    lock (RecMsgs)
                        RecMsgs.Remove(msg);
        }
        #endregion

        #region 表情和头像图片
        /// <summary>
        /// 表情图片列表缓存
        /// </summary>
        //public static List<Image> ImageFaces = new List<Image>();
        /// <summary>
        /// 头像图片列表缓存
        /// </summary>
        public static Dictionary<string, Image> HeadImages = new Dictionary<string, Image>();

        public static Image DefaultUserImage = OurMsg.Properties.Resources.user;

        public static Image DefaultRoomImage = OurMsg.Properties.Resources.room;

        #region 添加默认图片
        /// <summary>
        /// 添加默认图片
        /// </summary>
        public static void AddDefaultImage()
        {
            string User1 = "User_32", User2 = "User_20", User3 = "User_24";
            string Room1 = "Room_32", Room2 = "Room_20", Room3 = "Room_24";
            HeadImages.Add(User1, DefaultUserImage.GetThumbnailImage(32, 32, null, IntPtr.Zero));
            HeadImages.Add(User2, DefaultUserImage.GetThumbnailImage(20, 20, null, IntPtr.Zero));
            HeadImages.Add(User3, DefaultRoomImage.GetThumbnailImage(24, 24, null, IntPtr.Zero));
            HeadImages.Add(Room1, DefaultRoomImage.GetThumbnailImage(32, 32, null, IntPtr.Zero));
            HeadImages.Add(Room2, DefaultRoomImage.GetThumbnailImage(20, 20, null, IntPtr.Zero));
            HeadImages.Add(Room3, DefaultRoomImage.GetThumbnailImage(24, 24, null, IntPtr.Zero));
        }
        #endregion

        #region 获取指定尺寸的头像
        /// <summary>
        /// 获得指定尺寸的头像
        /// </summary>
        /// <param name="headID"></param>
        /// <param name="size"></param>
        /// <returns></returns>
        public static Image GetHeadImage(Int32  headID, ImageSize size)
        {
           return  GetHeadImage (headID.ToString(),size);
        }
        /// <summary>
        /// 获得指定尺寸的头像
        /// </summary>
        /// <param name="headID"></param>
        /// <param name="size"></param>
        /// <returns></returns>
        public static Image GetHeadImage (string headID, ImageSize size)
        {
            Image head = DefaultUserImage;
            var x = Convert.ToInt32(size);
            string imageID = headID + "_" + x.ToString();
            Image tempImage = null;
            HeadImages.TryGetValue(imageID, out tempImage);
            if (tempImage == null)
            {
                FileInfo finfo = new FileInfo("head\\" + headID + ".bmp");
                if (finfo.Exists)
                {
                    tempImage = Image.FromFile(finfo.FullName);
                    tempImage = tempImage.GetThumbnailImage(x, x, null, IntPtr.Zero);
                    HeadImages.Add(imageID, tempImage);
                    return tempImage;
                }
            }
            else
                return tempImage;

            return head.GetThumbnailImage(x, x, null, IntPtr.Zero);
        }
        #endregion

        #endregion

        #region 注释代码
        //public static void DrawImage(Image image)
        //{

        //    int bordwidth = Convert.ToInt32(image.Width * 0.1);
        //    int bordheight = Convert.ToInt32(image.Height * 0.1);

        //    int newheight = image.Height + bordheight;
        //    int newwidth = image.Width + bordwidth;

        //    Color bordcolor = Color.Black;
        //    Bitmap bmp = new Bitmap(newwidth, newheight);
        //    Graphics g = Graphics.FromImage(bmp);

        //    g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;
        //    g.CompositingQuality = System.Drawing.Drawing2D.CompositingQuality.HighQuality;
        //    g.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.High;

        //    int Style = 0; //New: 绘制边框的类型, 手动修改0,1,2 可改变边框类型
        //    if (Style == 0) //New: 整个边框.
        //    {
        //        //Changed: 修改rec区域, 将原图缩放. 适合边框内
        //        System.Drawing.Rectangle rec = new Rectangle(bordwidth / 2, bordwidth / 2, newwidth - bordwidth / 2, newheight - bordwidth / 2);
        //        g.DrawImage(image, rec, 0, 0, image.Width, image.Height, GraphicsUnit.Pixel);
        //        g.DrawRectangle(new Pen(bordcolor, bordheight), 0, 0, newwidth, newheight);
        //    }
        //    else if (Style == 1) //New: 上下边框.
        //    {
        //        System.Drawing.Rectangle rec = new Rectangle(0, bordwidth / 2, newwidth, newheight - bordwidth / 2);
        //        g.DrawImage(image, rec, 0, 0, image.Width, image.Height, GraphicsUnit.Pixel);
        //        g.DrawLine(new Pen(bordcolor, bordheight), 0, 0, newwidth, 0);
        //        g.DrawLine(new Pen(bordcolor, bordheight), 0, newheight, newwidth, newheight);
        //    }
        //    else if (Style == 2) //New: 左右边框.
        //    {
        //        System.Drawing.Rectangle rec = new Rectangle(bordwidth / 2, 0, newwidth - bordwidth / 2, newheight);
        //        g.DrawImage(image, rec, 0, 0, image.Width, image.Height, GraphicsUnit.Pixel);
        //        g.DrawLine(new Pen(bordcolor, bordheight), 0, 0, 0, newheight);
        //        g.DrawLine(new Pen(bordcolor, bordheight), newwidth, 0, newwidth, newheight);
        //    }

        //    bmp.Save(DateTime.Now.ToString("mmssfff") + ".jpg");
        //    g.Dispose();
        //}
        #endregion

        #region 显示消息
        public static void ShowMessage(string content)
        {
            if (content != null)
                MessageBox.Show(content, "提示", MessageBoxButtons.OK, MessageBoxIcon.Information);
        }


        public static DialogResult ShowYNCMessage(string content)
        {
            return MessageBox.Show(content, "提示", MessageBoxButtons.YesNoCancel, MessageBoxIcon.Information);
        }
        #endregion
    }
}
